/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache;

import jakarta.annotation.PostConstruct;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.documents.storage.jcr.webdav.JcrWebDavService;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity.WebDavItemEntity;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity.WebDavItemPropertyEntity;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.repository.WebDavItemRepository;
import org.exoplatform.documents.storage.jcr.webdav.cache.listener.WebDavCacheUpdaterAction;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavReadCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavWriteCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.impl.RepositoryServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.stereotype.Service;

@Service
public class CachedJcrWebDavService
extends JcrWebDavService {
    protected static final Log LOG = ExoLogger.getLogger(CachedJcrWebDavService.class);
    private WebDavItemRepository webDavItemRepository;

    public CachedJcrWebDavService(WebdavReadCommandHandler readCommandHandler, WebdavWriteCommandHandler writeCommandHandler, RepositoryServiceImpl repositoryService, UserACL userAcl, WebDavItemRepository webDavItemRepository) {
        super(readCommandHandler, writeCommandHandler, repositoryService, userAcl);
        this.webDavItemRepository = webDavItemRepository;
    }

    @PostConstruct
    public void init() {
        this.webDavItemRepository.deleteAll();
        this.addCacheEventListener();
    }

    @Override
    public boolean isFile(String webDavPath) {
        if (StringUtils.isBlank((CharSequence)webDavPath) || StringUtils.equals((CharSequence)webDavPath, (CharSequence)"/")) {
            return false;
        }
        WebDavItemEntity webDavItemEntity = this.findCacheEntry(webDavPath);
        if (webDavItemEntity == null) {
            return super.isFile(webDavPath);
        }
        return webDavItemEntity.isFile();
    }

    @Override
    public long getLastModifiedDate(String webDavPath, String version) throws WebDavException {
        if (StringUtils.isBlank((CharSequence)webDavPath) || StringUtils.equals((CharSequence)webDavPath, (CharSequence)"/")) {
            return 0L;
        }
        WebDavItemEntity webDavItemEntity = this.findCacheEntry(webDavPath);
        if (webDavItemEntity == null) {
            return super.getLastModifiedDate(webDavPath, version);
        }
        return webDavItemEntity.getProperties() == null ? 0L : webDavItemEntity.getProperties().stream().filter(p -> PropertyConstants.GETLASTMODIFIED.equals(WebDavItemProperty.toQname((String)p.getName()))).map(WebDavItemPropertyEntity::getValue).filter(StringUtils::isNotBlank).map(this::getModifiedDateMillis).findFirst().orElse(0L);
    }

    @Override
    public WebDavItem get(String webDavPath, String propRequestType, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri, String username) throws WebDavException {
        WebDavItem webDavItem;
        if (StringUtils.isBlank((CharSequence)webDavPath) || StringUtils.equals((CharSequence)webDavPath, (CharSequence)"/")) {
            return super.get(webDavPath, propRequestType, requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri, username);
        }
        WebDavItemEntity webDavItemEntity = this.findCacheEntry(webDavPath);
        if (this.isMustRefreshItem(webDavItemEntity, username, depth) && (webDavItem = super.get(webDavPath, propRequestType, null, false, depth, baseUri, username)) != null) {
            webDavItemEntity = this.saveWebDavItem(webDavItem, username, this.isMustReloadUsers(webDavItemEntity), depth);
        }
        if (webDavItemEntity == null) {
            return null;
        }
        webDavItem = webDavItemEntity.toWebDavItem();
        if (depth > 0) {
            this.addChildren(webDavItem, depth, baseUri, username);
        }
        return webDavItem;
    }

    public void clearCache(String jcrPath, boolean drop) {
        String parentJcrPath;
        WebDavItemEntity parentWebDavItemEntity;
        WebDavItemEntity webDavItemEntity = this.webDavItemRepository.findByJcrPath(jcrPath);
        if (webDavItemEntity != null) {
            LOG.debug("Clear WebDav Item from ES Cache with path '{}' and option drop = '{}'", new Object[]{jcrPath, drop});
            if (drop) {
                this.webDavItemRepository.delete(webDavItemEntity);
            } else if (!webDavItemEntity.isModified()) {
                webDavItemEntity.setModified(true);
                this.webDavItemRepository.save(webDavItemEntity);
            }
        }
        if ((parentWebDavItemEntity = this.webDavItemRepository.findByJcrPath(parentJcrPath = jcrPath.substring(0, jcrPath.lastIndexOf("/")))) != null && !parentWebDavItemEntity.isModified() && drop) {
            LOG.debug("Clear WebDav Item from ES Cache with path '{}'", new Object[]{jcrPath});
            parentWebDavItemEntity.setModified(true);
            parentWebDavItemEntity.setDeep(false);
            this.webDavItemRepository.save(parentWebDavItemEntity);
        }
    }

    private void addChildren(WebDavItem webDavItem, int depth, String baseUri, String username) {
        List<WebDavItemEntity> children = this.webDavItemRepository.findByParentWebDavPath(webDavItem.getWebDavPath());
        int childrenDepth = depth - 1;
        children.stream().map(c -> {
            WebDavItem childWebDavItem = null;
            if (!c.isModified() && c.getUsernames().contains(username) && (c.isDeep() || childrenDepth == 0)) {
                childWebDavItem = c.toWebDavItem();
            } else {
                try {
                    childWebDavItem = this.get(c.getWebDavPath(), "allprop", null, false, childrenDepth, baseUri, username);
                }
                catch (Exception e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("It seems that user isn't allowed to access {}. Continue for other child nodes", new Object[]{c.getWebDavPath(), e});
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("It seems that user isn't allowed to access {}. Continue for other child nodes. Error: {}", new Object[]{c.getWebDavPath(), e.getMessage()});
                    }
                    return null;
                }
            }
            if (childrenDepth > 0) {
                this.addChildren(childWebDavItem, childrenDepth, baseUri, username);
            }
            return childWebDavItem;
        }).filter(Objects::nonNull).forEach(arg_0 -> ((WebDavItem)webDavItem).addChild(arg_0));
    }

    private WebDavItemEntity saveWebDavItem(WebDavItem webDavItem, String username, boolean forceRefreshUsers, int depth) {
        LOG.debug("Save WebDav Item with path '{}' in ES Cache", new Object[]{webDavItem.getWebDavPath()});
        WebDavItemEntity webDavItemEntity = new WebDavItemEntity(webDavItem);
        webDavItemEntity.setDeep(depth > 0);
        if (forceRefreshUsers) {
            webDavItemEntity.setUsernames(Collections.singleton(username));
        } else {
            WebDavItemEntity existingWebDavItemEntity = this.webDavItemRepository.findById(webDavItemEntity.getIdentifier()).orElse(null);
            if (existingWebDavItemEntity == null) {
                webDavItemEntity.setUsernames(Collections.singleton(username));
            } else {
                HashSet<String> usernames = new HashSet<String>(existingWebDavItemEntity.getUsernames());
                usernames.add(username);
                webDavItemEntity.setUsernames(usernames);
                webDavItemEntity.setDeep(existingWebDavItemEntity.isDeep() || depth > 0);
            }
        }
        webDavItemEntity = (WebDavItemEntity)this.webDavItemRepository.save(webDavItemEntity);
        if (CollectionUtils.isNotEmpty((Collection)webDavItem.getChildren())) {
            int childrenDepth = depth - 1;
            webDavItem.getChildren().forEach(c -> this.saveWebDavItem((WebDavItem)c, username, forceRefreshUsers, childrenDepth));
        }
        return webDavItemEntity;
    }

    private Long getModifiedDateMillis(String modifiedDateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            dateFormat.setTimeZone(Tools.getTimeZone((String)"GMT"));
            return dateFormat.parse(modifiedDateString).getTime();
        }
        catch (Exception e) {
            LOG.warn("Error while parsing modified date value {}", new Object[]{modifiedDateString, e});
            return 0L;
        }
    }

    private WebDavItemEntity findCacheEntry(String webDavPath) {
        String id = Arrays.stream(webDavPath.split("/")).filter(StringUtils::isNotBlank).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20")).collect(Collectors.joining("/"));
        return this.webDavItemRepository.findById("/" + id).orElse(null);
    }

    private boolean isMustReloadUsers(WebDavItemEntity webDavItemEntity) {
        return webDavItemEntity == null || webDavItemEntity.isModified();
    }

    private boolean isMustRefreshItem(WebDavItemEntity webDavItemEntity, String username, int depth) {
        return webDavItemEntity == null || webDavItemEntity.isModified() || depth > 0 && !webDavItemEntity.isDeep() || !webDavItemEntity.getUsernames().contains(username);
    }

    private void addCacheEventListener() {
        Session session = this.getSession();
        try {
            ObservationManager observation = session.getWorkspace().getObservationManager();
            WebDavCacheUpdaterAction.SUPPORTED_PATHS.forEach(path -> this.addCacheEventListener(observation, this.createCacheListenerInstance(), (String)path));
        }
        finally {
            session.logout();
        }
    }

    private void addCacheEventListener(ObservationManager observation, WebDavCacheUpdaterAction cacheUpdaterAction, String path) {
        observation.addEventListener((EventListener)cacheUpdaterAction, WebDavCacheUpdaterAction.SUPPORTED_EVENT_TYPES, path, true, null, (String[])WebDavCacheUpdaterAction.SUPPORTED_NODE_TYPES.toArray(String[]::new), false);
    }

    private WebDavCacheUpdaterAction createCacheListenerInstance() {
        return new WebDavCacheUpdaterAction(this);
    }
}

