/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.service.PublicDocumentAccessService;
import org.exoplatform.documents.storage.PublicDocumentAccessStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class PublicDocumentAccessServiceImpl
implements PublicDocumentAccessService {
    private static final Log LOG = ExoLogger.getLogger(PublicDocumentAccessServiceImpl.class);
    private PublicDocumentAccessStorage publicDocumentAccessStorage;
    private final AbstractCodec codec;
    private static final String HASHING_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final int HASHING_ALGORITHM_ITERATIONS = 65536;
    private static final int HASH_KEY_LENGTH = 256;

    public PublicDocumentAccessServiceImpl(PublicDocumentAccessStorage publicDocumentAccessStorage, CodecInitializer codecInitializer) throws TokenServiceInitializationException {
        this.publicDocumentAccessStorage = publicDocumentAccessStorage;
        this.codec = codecInitializer.getCodec();
    }

    public PublicDocumentAccess createPublicDocumentAccess(long docOwnerId, String nodeId, String password, Long expirationDate, boolean hasPassword) {
        try {
            PublicDocumentAccess publicDocumentAccess = this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId(nodeId);
            Date expiration = expirationDate != 0L ? new Date(expirationDate) : null;
            long id = publicDocumentAccess != null ? publicDocumentAccess.getId() : 0L;
            String hashKey = null;
            String encodedPassword = null;
            if (password != null) {
                hashKey = this.generatePasswordHash(password);
                encodedPassword = this.codec.encode(password);
            } else if (hasPassword && publicDocumentAccess != null) {
                hashKey = publicDocumentAccess.getPasswordHashKey();
                encodedPassword = publicDocumentAccess.getEncodedPassword();
            }
            publicDocumentAccess = this.publicDocumentAccessStorage.savePublicDocumentAccess(new PublicDocumentAccess(Long.valueOf(id), nodeId, hashKey, encodedPassword, expiration), docOwnerId);
            publicDocumentAccess.setDecodedPassword(password);
            return publicDocumentAccess;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating document public access", (Throwable)e);
            return null;
        }
    }

    private String generatePasswordHash(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.codec.encode(password);
        SecureRandom secureRandom = new SecureRandom();
        byte[] salt = new byte[16];
        secureRandom.nextBytes(salt);
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(HASHING_ALGORITHM);
        byte[] hash = factory.generateSecret(keySpec).getEncoded();
        return "65536:" + Hex.encodeHexString((byte[])salt) + ":" + Hex.encodeHexString((byte[])hash);
    }

    private static boolean validatePassword(String password, String hashKey) {
        try {
            String[] parts = hashKey.split(":");
            int iterations = Integer.parseInt(parts[0]);
            byte[] salt = Hex.decodeHex((char[])parts[1].toCharArray());
            byte[] hash = Hex.decodeHex((char[])parts[2].toCharArray());
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray(), salt, iterations, hash.length * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(HASHING_ALGORITHM);
            byte[] checkHash = secretKeyFactory.generateSecret(pbeKeySpec).getEncoded();
            int diff = hash.length ^ checkHash.length;
            for (int i = 0; i < hash.length && i < checkHash.length; ++i) {
                diff |= hash[i] ^ checkHash[i];
            }
            return diff == 0;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while validating document public access password", (Throwable)e);
            return false;
        }
    }

    public PublicDocumentAccess getPublicDocumentAccess(String documentId) {
        PublicDocumentAccess publicDocumentAccess = this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId(documentId);
        if (publicDocumentAccess != null && publicDocumentAccess.getEncodedPassword() != null) {
            publicDocumentAccess.setDecodedPassword(this.codec.decode(publicDocumentAccess.getEncodedPassword()));
        }
        return publicDocumentAccess;
    }

    public boolean isPublicDocumentAccessExpired(String documentId) {
        PublicDocumentAccess publicDocumentAccess = this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId(documentId);
        if (publicDocumentAccess == null) {
            return true;
        }
        Date expiration = publicDocumentAccess.getExpirationDate();
        return expiration != null && expiration.before(new Date());
    }

    public boolean isDocumentPublicAccessValid(String documentId, String password) {
        PublicDocumentAccess publicDocumentAccess = this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId(documentId);
        if (publicDocumentAccess == null) {
            return false;
        }
        if (publicDocumentAccess.getPasswordHashKey() == null) {
            return true;
        }
        return PublicDocumentAccessServiceImpl.validatePassword(password, publicDocumentAccess.getPasswordHashKey());
    }

    public boolean hasDocumentPublicAccess(String documentId) {
        return this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId(documentId) != null;
    }

    public void revokeDocumentPublicAccess(String documentId) {
        this.publicDocumentAccessStorage.removePublicDocumentAccess(documentId);
    }
}

