const path = require('path');
const ESLintPlugin = require('eslint-webpack-plugin');
const { VueLoaderPlugin } = require('vue-loader')

const config = {
  mode: 'production',
  context: path.resolve(__dirname, '.'),
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: [
          'babel-loader',
        ]
      },
      {
        test: /\.vue$/,
        use: [
          'vue-loader',
        ]
      }
    ]
  },
  plugins: [
    new ESLintPlugin({
      files: [
        './src/main/webapp/vue-app/*.js',
        './src/main/webapp/vue-app/*.vue',
        './src/main/webapp/vue-app/**/*.js',
        './src/main/webapp/vue-app/**/*.vue',
      ],
    }),
    new VueLoaderPlugin()
  ],
  entry: {
    documents: './src/main/webapp/vue-app/documents/main.js',
    documentsSnackbarComponent : './src/main/webapp/vue-app/snackbar/main.js',
    documentsFavoriteDrawerExtensions: './src/main/webapp/vue-app/documents-favorite-drawer-extensions/main.js',
    documentsSizeGadget: './src/main/webapp/vue-app/documents-size-gadget/main.js',
    downloadDocumentsPublicAccess: './src/main/webapp/vue-app/download-document/main.js',
    notificationExtension: './src/main/webapp/vue-app/notification-extension/main.js',
  },
  output: {
    path: path.join(__dirname, 'target/documents-portlet/'),
    filename: 'js/[name].bundle.js',
    libraryTarget: 'amd'
  },
  externals: {
    vue: 'Vue',
    vuetify: 'Vuetify',
    jquery: '$',
  },
};

module.exports = config;
