/*
 * Copyright (C) 2024 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

export function getDeletedDocuments(limit, offset, sortField, sortDirection) {
  const formData = new FormData();
  if (limit) {
    formData.append('limit', limit);
  }
  if (offset) {
    formData.append('offset', offset);
  }
  if (sortField) {
    formData.append('sortField', sortField);
  }
  if (sortDirection) {
    formData.append('sortDirection', sortDirection);
  }
  const params = new URLSearchParams(formData).toString();
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/documents/deleted?${params}`, {
    method: 'GET',
    credentials: 'include',
  }).then(resp => {
    if (!resp || !resp.ok) {
      throw new Error('Response code indicates a server error', resp);
    } else {
      return resp.json();
    }
  });
}

export function restoreDocument(documentPath) {
  const formData = new FormData();
  formData.append('documentPath', documentPath);
  const params = new URLSearchParams(formData).toString();
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/documents/trash/restore?${params}`, {
    method: 'PUT',
    credentials: 'include',
  }).then(resp => {
    if (!resp || !resp.ok) {
      throw new Error('Response code indicates a server error', resp);
    } else {
      return resp;
    }
  });
}

export function deleteDocumentPermanently(documentPath) {
  const formData = new FormData();
  formData.append('documentPath', documentPath);
  const params = new URLSearchParams(formData).toString();
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/documents/trash/delete?${params}`, {
    method: 'DELETE',
    credentials: 'include',
  }).then(resp => {
    if (!resp || !resp.ok) {
      throw new Error('Response code indicates a server error', resp);
    } else {
      return resp;
    }
  });
}

export function deleteDocumentsPermanently(actionId, documents) {
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/documents/trash/bulk/delete/${actionId}`, {
    method: 'DELETE',
    credentials: 'include',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify(documents),
  }).then((resp) => {
    if (resp && !resp.ok) {
      throw new Error('Error when deleting document');
    }
  });
}

export function restoreDocumentsPermanently(actionId, documents) {
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/documents/trash/bulk/restore/${actionId}`, {
    method: 'PUT',
    credentials: 'include',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify(documents),
  }).then((resp) => {
    if (resp && !resp.ok) {
      throw new Error('Error when deleting document');
    }
  });
}