/**
 * Copyright (C) 2025 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
*/
package org.exoplatform.documents.webdav.plugin.impl;

import java.util.List;

import org.springframework.stereotype.Component;

import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@Component
public class MoveWebDavHandler extends WebDavHttpMethodPlugin {

  public MoveWebDavHandler() {
    super("MOVE");
  }

  @Override
  public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
    String resourcePath = getResourcePath(httpRequest);
    String destinationPath = getDestinationPath(httpRequest);
    List<String> lockTokens = getLockTokens(httpRequest);
    boolean overwrite = getOverwriteParameter(httpRequest);

    boolean itemExists = documentWebDavService.move(resourcePath,
                                                    destinationPath,
                                                    overwrite,
                                                    lockTokens,
                                                    httpRequest.getRemoteUser());
    httpResponse.setStatus(itemExists ? HttpServletResponse.SC_NO_CONTENT : HttpServletResponse.SC_CREATED);
  }

}
