/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.rest.model.AbstractNodeEntity;
import org.exoplatform.documents.rest.model.FileNodeEntity;
import org.exoplatform.documents.rest.model.NodePermissionEntity;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.documents.rest.util.RestUtils;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;

@Path(value="/v1/documents")
@Api(value="/v1/documents", description="Manages documents associated to users and spaces")
public class DocumentFileRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(DocumentFileRest.class);
    private final DocumentFileService documentFileService;
    private final SpaceService spaceService;
    private final MetadataService metadataService;
    private final IdentityManager identityManager;

    public DocumentFileRest(DocumentFileService documentFileService, SpaceService spaceService, IdentityManager identityManager, MetadataService metadataService) {
        this.documentFileService = documentFileService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.metadataService = metadataService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the list of document items (folders and files) for an authenticated user switch filter.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDocumentItems(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="Parent folder technical identifier", required=false) @QueryParam(value="parentFolderId") String parentFolderId, @ApiParam(value="Parent folder path", required=false) @QueryParam(value="folderPath") String folderPath, @ApiParam(value="Listing type of folder. Can be 'TIMELINE' or 'FOLDER'.", required=false) @QueryParam(value="listingType") FileListingType listingType, @ApiParam(value="Search query entered by the user", required=false) @QueryParam(value="query") String query, @ApiParam(value="userId", required=false) @QueryParam(value="userId") String userId, @ApiParam(value="favorites", required=false, defaultValue="false") @QueryParam(value="favorites") boolean favorites, @ApiParam(value="File properties to expand.", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Document items sort field", required=false) @QueryParam(value="sortField") String sortField, @ApiParam(value="Sort ascending or descending", required=false) @QueryParam(value="ascending") boolean ascending, @ApiParam(value="Offset of results to return", required=false, defaultValue="10") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of results to return", required=false, defaultValue="10") @QueryParam(value="limit") int limit) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentFolderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        if (listingType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"listingType_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            DocumentTimelineFilter filter = listingType == FileListingType.TIMELINE ? new DocumentTimelineFilter(ownerId) : new DocumentFolderFilter(parentFolderId, folderPath, ownerId);
            filter.setQuery(query);
            filter.setFavorites(Boolean.valueOf(favorites));
            filter.setUserId(userId);
            filter.setAscending(ascending);
            filter.setSortField(DocumentSortField.getFromAlias((String)sortField));
            List documents = this.documentFileService.getDocumentItems(listingType, (DocumentNodeFilter)filter, offset, limit, userIdentityId);
            List<AbstractNodeEntity> documentEntities = EntityBuilder.toDocumentItemEntities(this.documentFileService, this.identityManager, this.spaceService, this.metadataService, documents, expand, userIdentityId);
            return Response.ok(documentEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized documents of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of documents", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/group/count")
    @ApiOperation(value="Get documents groups sizes.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDocumentGroupsCount(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @QueryParam(value="parentFolderId") String parentFolderId, @ApiParam(value="Search query entered by the user", required=false) @QueryParam(value="query") String query, @ApiParam(value="favorites", required=false, defaultValue="false") @QueryParam(value="favorites") boolean favorites) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentFolderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            DocumentTimelineFilter filter = new DocumentTimelineFilter(ownerId);
            filter.setQuery(query);
            filter.setFavorites(Boolean.valueOf(favorites));
            DocumentGroupsSize documentGroupsSize = this.documentFileService.getGroupDocumentsCount(filter, userIdentityId);
            return Response.ok((Object)documentGroupsSize).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized documents of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of documents", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/breadcrumb")
    @ApiOperation(value="Get breadcrumb of given .", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getBreadcrumb(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="Folder technical identifier", required=false) @QueryParam(value="folderId") String folderId, @ApiParam(value="Folder path", required=false) @QueryParam(value="folderPath") String folderPath) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)folderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            return Response.ok(EntityBuilder.toBreadCrumbItemEntities(this.documentFileService.getBreadcrumb(ownerId.longValue(), folderId, folderPath, userIdentityId))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving breadcrumb", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/fullTree")
    @ApiOperation(value="Get Full Tree of given .", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getFullTreeData(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="Folder technical identifier", required=false) @QueryParam(value="folderId") String folderId) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)folderId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_folderId_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            return Response.ok(EntityBuilder.toFullTreeItemEntities(this.documentFileService.getFullTreeData(ownerId.longValue(), folderId, userIdentityId))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving tree folder", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/duplicate")
    @ApiOperation(value="POST DUPLICATE of given .", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response duplicateDocument(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="File technical identifier", required=false) @QueryParam(value="fileId") String fileId, @ApiParam(value="File prefix Clone", required=false) @QueryParam(value="prefixClone") String prefixClone, @ApiParam(value="File properties to expand.", required=false) @QueryParam(value="expand") String expand) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)fileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_FileID_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AbstractNode abstractNode = this.documentFileService.duplicateDocument(ownerId.longValue(), fileId, prefixClone, userIdentityId);
            AbstractNodeEntity abstractNodeEntity = EntityBuilder.toDocumentItemEntity(this.documentFileService, this.identityManager, this.spaceService, this.metadataService, abstractNode, expand, userIdentityId);
            return Response.ok((Object)abstractNodeEntity).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving duplicate file", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/move")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Move documents", httpMethod="POST", response=Response.class, notes="This rename a giving document.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response moveDocument(@ApiParam(value="documentID", required=false) @QueryParam(value="documentID") String documentID, @ApiParam(value="ownerId", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="new path", required=false) @QueryParam(value="destPath") String destPath) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)documentID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_documentID_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)destPath)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document destination path should not be empty").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.moveDocument(ownerId.longValue(), documentID, destPath, userIdentityId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to rename Document", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/folder")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Add a new Folder", httpMethod="POST", response=Response.class, notes="This adds a new Folder under givin Folder.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response createFolder(@ApiParam(value="parentid", required=false) @QueryParam(value="parentid") String parentid, @ApiParam(value="folderPath", required=false) @QueryParam(value="folderPath") String folderPath, @ApiParam(value="ownerId", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="folder name", required=false) @QueryParam(value="name") String name) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_parentid_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be empty").build();
        }
        if (NumberUtils.isNumber((String)name)) {
            LOG.warn((Object)"Folder Name should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be number").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.createFolder(ownerId.longValue(), parentid, folderPath, name, userIdentityId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to create Folder", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/newname")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="propose a new name for Folder is there is already a folder with the provided name", httpMethod="GET", response=Response.class, notes="propse a new name for Folder is there is already a folder with the provided name")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getNewName(@ApiParam(value="parentid", required=false) @QueryParam(value="parentid") String parentid, @ApiParam(value="folderPath", required=false) @QueryParam(value="folderPath") String folderPath, @ApiParam(value="ownerId", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="folder name", required=false) @QueryParam(value="name") String name) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)parentid)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_parentid_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be empty").build();
        }
        if (NumberUtils.isNumber((String)name)) {
            LOG.warn((Object)"Folder Name should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Folder Name should not be number").build();
        }
        try {
            return Response.ok((Object)this.documentFileService.getNewName(ownerId.longValue(), parentid, folderPath, name)).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to propose new Folder name", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Path(value="/rename")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Rename documents", httpMethod="POST", response=Response.class, notes="This rename a giving document.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response renameDocument(@ApiParam(value="documentID", required=false) @QueryParam(value="documentID") String documentID, @ApiParam(value="ownerId", required=false) @QueryParam(value="ownerId") Long ownerId, @ApiParam(value="new name", required=false) @QueryParam(value="newName") String newName) {
        if (ownerId == null && StringUtils.isBlank((CharSequence)documentID)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"either_ownerId_or_documentID_is_mandatory").build();
        }
        if (StringUtils.isEmpty((CharSequence)newName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Document Name should not be empty").build();
        }
        try {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            this.documentFileService.renameDocument(ownerId.longValue(), documentID, newName, userIdentityId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to rename Document", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="{documentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete document", httpMethod="DELETE", response=Response.class, notes="This deletes document", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Document deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the document"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteDocument(@ApiParam(value="Document id", required=true) @PathParam(value="documentId") String documentId, @ApiParam(value="folder path", required=true) @QueryParam(value="documentPath") String documentPath, @ApiParam(value="Is favorite document", required=false) @QueryParam(value="favorite") boolean favorite, @ApiParam(value="Time to effectively delete document", required=false) @QueryParam(value="delay") long delay) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"document_id_is_mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)documentPath)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"document_path_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        String originPath = documentPath.replace(":", "/");
        try {
            this.documentFileService.deleteDocument(originPath, documentId, favorite, delay, userIdentityId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news target with name " + userIdentityId), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{documentId}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Undo deleting document if not yet effectively deleted.", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation")})
    public Response undoDeleteDocument(@ApiParam(value="Document identifier", required=true) @PathParam(value="documentId") String documentId) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"document_id_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        this.documentFileService.undoDeleteDocument(documentId, userIdentityId);
        return Response.noContent().build();
    }

    @Path(value="permissions")
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Undo deleting document if not yet effectively deleted.", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation")})
    public Response updatePermissions(@ApiParam(value="Permission object", required=true) FileNodeEntity nodeEntity) {
        if (nodeEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"node_object_is_mandatory").build();
        }
        NodePermissionEntity nodePermissionEntity = nodeEntity.getAcl();
        if (nodePermissionEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"permissions_object_is_mandatory").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.documentFileService.updatePermissions(nodeEntity.getId(), EntityBuilder.toNodePermission(nodeEntity, this.documentFileService, this.spaceService, this.identityManager), userIdentityId);
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }
}

