/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.util.Collection;
import java.util.HashSet;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.websocket.entity.WebSocketMessage;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class DocumentWebSocketService {
    private static final Log LOG = ExoLogger.getLogger(DocumentWebSocketService.class);
    public static final String COMETD_CHANNEL = "/eXo/Application/Addons/Documents";
    private ContinuationService continuationService;
    private String cometdContextName;

    public DocumentWebSocketService(ContinuationService continuationService, EXoContinuationBayeux continuationBayeux) {
        this.continuationService = continuationService;
        this.cometdContextName = continuationBayeux.getCometdContextName();
    }

    public void sendMessage(String wsEventName, ActionData actionData, Identity identity) {
        HashSet<String> recipientUsers = new HashSet<String>();
        String remoteId = identity.getUserId();
        recipientUsers.add(remoteId);
        this.sendMessage(wsEventName, recipientUsers, actionData);
    }

    public void sendMessage(String wsEventName, Collection<String> recipientUsers, Object ... params) {
        WebSocketMessage messageObject = new WebSocketMessage(wsEventName, params);
        this.sendMessage(messageObject, recipientUsers);
    }

    public void sendMessage(WebSocketMessage messageObject, Collection<String> recipientUsers) {
        String message = messageObject.toString();
        for (String recipientUser : recipientUsers) {
            if (!this.continuationService.isPresent(recipientUser)) continue;
            this.continuationService.sendMessage(recipientUser, COMETD_CHANNEL, (Object)message);
        }
    }

    public String getCometdContextName() {
        return this.cometdContextName;
    }

    public String getUserToken(String username) {
        try {
            return this.continuationService.getUserToken(username);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
            return "";
        }
    }
}

