/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.provider;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

@TemplateConfigs(templates={@TemplateConfig(pluginId="AddDocumentCollaboratorPlugin", template="war:/notification/templates/push/AddDocumentCollaboratorPlugin.gtmpl"), @TemplateConfig(pluginId="ImportDocumentsPlugin", template="war:/notification/templates/push/ImportDocumentsPlugin.gtmpl")})
public class PushTemplateProvider
extends TemplateProvider {
    private final IdentityManager identityManager;

    public PushTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"AddDocumentCollaboratorPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ImportDocumentsPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String fromUser = notificationInfo.getValueOwnerParameter(NotificationConstants.FROM_USER.getKey());
            String documentName = notificationInfo.getValueOwnerParameter(NotificationConstants.DOCUMENT_NAME.getKey());
            String folderName = notificationInfo.getValueOwnerParameter(NotificationConstants.FOLDER_NAME.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"DOCUMENT_NAME", (Object)documentName);
            templateContext.put((Object)"FOLDER_NAME", (Object)folderName);
            Profile userProfile = NotificationUtils.getUserProfile(PushTemplateProvider.this.identityManager, fromUser);
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

