/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.documents.service.DocumentWebSocketService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.Identity;

public class BulkActionDocumentListener
extends Listener<Identity, ActionData> {
    private final DocumentWebSocketService documentWebSocketService;

    public BulkActionDocumentListener(DocumentWebSocketService documentWebSocketService) {
        this.documentWebSocketService = documentWebSocketService;
    }

    public void onEvent(Event<Identity, ActionData> event) throws Exception {
        ActionData actionData = (ActionData)event.getData();
        Identity identity = (Identity)event.getSource();
        if (!actionData.getStatus().equals(ActionStatus.IMPORT_LIMIT_EXCEEDED.name()) && !actionData.getStatus().equals(ActionStatus.IMPORT_LIMIT_NOT_EXCEEDED.name())) {
            this.documentWebSocketService.sendMessage(actionData.getActionType(), actionData, identity);
        } else {
            this.documentWebSocketService.sendBroadcastMessage(actionData.getActionType(), actionData);
        }
        if (actionData.getActionType().equals(ActionType.IMPORT_ZIP.name()) && actionData.getStatus().equals(ActionStatus.DONE_SUCCESSFULLY.name())) {
            this.sendNotification(actionData, identity);
        }
    }

    private void sendNotification(ActionData importData, Identity identity) {
        Object filesCreated = "";
        Object filesDuplicated = "";
        Object filesUpdated = "";
        Object filesIgnored = "";
        Object filesFailed = "";
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationConstants.FROM_USER, (Object)identity.getUserId());
        ctx.append(NotificationConstants.FOLDER_URL, (Object)importData.getParentFolder());
        ctx.append(NotificationConstants.FOLDER_NAME, (Object)importData.getParentFolderName());
        ctx.append(NotificationConstants.TOTAL_NUMBER, (Object)String.valueOf(importData.getImportedFilesCount()));
        ctx.append(NotificationConstants.DURATION, (Object)String.valueOf((int)(importData.getDuration() / 1000L)));
        if (!importData.getCreatedFiles().isEmpty()) {
            filesCreated = "<li>" + String.join((CharSequence)"</li><li>", importData.getCreatedFiles()) + "</li>";
        }
        if (!importData.getDuplicatedFiles().isEmpty()) {
            filesDuplicated = "<li>" + String.join((CharSequence)"</li><li>", importData.getDuplicatedFiles()) + "</li>";
        }
        if (!importData.getUpdatedFiles().isEmpty()) {
            filesUpdated = "<li>" + String.join((CharSequence)"</li><li>", importData.getUpdatedFiles()) + "</li>";
        }
        if (!importData.getIgnoredFiles().isEmpty()) {
            filesIgnored = "<li>" + String.join((CharSequence)"</li><li>", importData.getIgnoredFiles()) + "</li>";
        }
        if (!importData.getFailedFiles().isEmpty()) {
            filesFailed = "<li>" + String.join((CharSequence)"</li><li>", importData.getFailedFiles()) + "</li>";
        }
        ctx.append(NotificationConstants.FILES_CREATED, filesCreated);
        ctx.append(NotificationConstants.FILES_DUPLICATED, filesDuplicated);
        ctx.append(NotificationConstants.FILES_UPDATED, filesUpdated);
        ctx.append(NotificationConstants.FILES_IGNORED, filesIgnored);
        ctx.append(NotificationConstants.FILES_FAILED, filesFailed);
        ctx.append(NotificationConstants.RECEIVERS, (Object)identity.getUserId());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ImportDocumentsPlugin"))).execute(ctx);
    }
}

