/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.rest.util;

import java.util.List;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.rest.model.AbstractNodeEntity;
import org.exoplatform.documents.rest.model.IdentityEntity;
import org.exoplatform.documents.rest.model.NodePermissionEntity;
import org.exoplatform.documents.rest.model.PermissionEntryEntity;
import org.exoplatform.documents.rest.model.Visibility;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EntityBuilderTest {
    @Mock
    private DocumentFileService documentFileService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private IdentityManager identityManager;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void toNodePermission() {
        AbstractNodeEntity abstractNodeEntity = new AbstractNodeEntity(true);
        NodePermissionEntity nodePermissionEntity = new NodePermissionEntity();
        NodePermission nodePermission = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNull((Object)nodePermission);
        abstractNodeEntity.setAcl(nodePermissionEntity);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Space space = new Space();
        space.setPrettyName("testspace");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/testspace")).thenReturn((Object)space);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("testspace")).thenReturn((Object)identity);
        abstractNodeEntity.setPath("path/spaces/testspace");
        NodePermission nodePermission1 = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNull((Object)nodePermission1);
        abstractNodeEntity.setPath("/Groups/spaces/testspace");
        PermissionEntryEntity permissionEntryEntity = new PermissionEntryEntity();
        IdentityEntity identityEntity = new IdentityEntity();
        identityEntity.setId("1");
        identityEntity.setRemoteId("remoteId");
        identityEntity.setProviderId("space");
        permissionEntryEntity.setIdentity(identityEntity);
        permissionEntryEntity.setPermission("read");
        nodePermissionEntity.setVisibilityChoice(Visibility.ALL_MEMBERS.name());
        nodePermissionEntity.setAllMembersCanEdit(true);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("remoteId")).thenReturn((Object)identity);
        nodePermissionEntity.setCollaborators(List.of(permissionEntryEntity));
        NodePermission nodePermission2 = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNotNull((Object)nodePermission2);
        nodePermissionEntity.setVisibilityChoice(Visibility.SPECIFIC_COLLABORATOR.name());
        nodePermissionEntity.setAllMembersCanEdit(false);
        NodePermission specificCollabotratorsNodePermission = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNotNull((Object)specificCollabotratorsNodePermission);
        Assert.assertEquals((Object)PermissionRole.MANAGERS_REDACTORS.name(), (Object)((PermissionEntry)specificCollabotratorsNodePermission.getPermissions().get(0)).getRole());
        Assert.assertEquals((Object)identity.getRemoteId(), (Object)((PermissionEntry)specificCollabotratorsNodePermission.getPermissions().get(0)).getIdentity().getRemoteId());
        Assert.assertEquals((Object)"edit", (Object)((PermissionEntry)specificCollabotratorsNodePermission.getPermissions().get(0)).getPermission());
        IdentityEntity useridentityEntity = new IdentityEntity();
        useridentityEntity.setId("1");
        useridentityEntity.setRemoteId("userRemoteId");
        useridentityEntity.setProviderId("user");
        permissionEntryEntity.setIdentity(useridentityEntity);
        permissionEntryEntity.setPermission("edit");
        Identity destinationIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)destinationIdentity.getRemoteId()).thenReturn((Object)"userRemoteId");
        Mockito.when((Object)destinationIdentity.getId()).thenReturn((Object)useridentityEntity.getId());
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(destinationIdentity.getRemoteId())).thenReturn((Object)destinationIdentity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"3");
        Mockito.when((Object)identity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"spaceTest");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName(identity.getRemoteId())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isMember(space, "userRemoteId")).thenReturn((Object)false);
        NodePermission nodePermission3 = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNotNull((Object)nodePermission3);
        Assert.assertEquals((Object)Long.valueOf(useridentityEntity.getId()), (Object)nodePermission3.getToShare().keySet().toArray()[0]);
        Mockito.when((Object)this.spaceService.isMember(space, "userRemoteId")).thenReturn((Object)true);
        NodePermission nodePermission4 = EntityBuilder.toNodePermission((AbstractNodeEntity)abstractNodeEntity, (DocumentFileService)this.documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertNotNull((Object)nodePermission3);
        Assert.assertEquals((Object)Long.valueOf(useridentityEntity.getId()), (Object)nodePermission4.getToNotify().keySet().toArray()[0]);
    }
}

