/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage;

import java.util.Date;
import org.exoplatform.documents.dao.PublicDocumentAccessDAO;
import org.exoplatform.documents.entity.PublicDocumentAccessEntity;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.storage.PublicDocumentAccessStorage;
import org.exoplatform.documents.storage.PublicDocumentAccessStorageImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PublicDocumentAccessStorageImplTest {
    private PublicDocumentAccessDAO publicDocumentAccessDAO;
    private IdentityManager identityManager;
    private PublicDocumentAccessStorage publicDocumentAccessStorage;

    @Before
    public void setUp() throws Exception {
        this.publicDocumentAccessDAO = (PublicDocumentAccessDAO)Mockito.mock(PublicDocumentAccessDAO.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.publicDocumentAccessStorage = new PublicDocumentAccessStorageImpl(this.publicDocumentAccessDAO, this.identityManager);
    }

    @Test
    public void getDocumentPublicAccessById() {
        PublicDocumentAccessEntity publicDocumentAccessEntity = new PublicDocumentAccessEntity();
        publicDocumentAccessEntity.setId(Long.valueOf(1L));
        publicDocumentAccessEntity.setNodeId("123");
        publicDocumentAccessEntity.setPasswordHashKey("hash");
        publicDocumentAccessEntity.setPasswordHashKey("100:test:test");
        publicDocumentAccessEntity.setExpirationDate(new Date());
        Mockito.when((Object)this.publicDocumentAccessDAO.getPublicDocumentAccessByNodeId("123")).thenReturn((Object)publicDocumentAccessEntity);
        Assert.assertNotNull((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123"));
    }

    @Test
    public void removeDocumentPublicAccess() {
        PublicDocumentAccessEntity publicDocumentAccessEntity = new PublicDocumentAccessEntity();
        Mockito.when((Object)this.publicDocumentAccessDAO.getPublicDocumentAccessByNodeId("123")).thenReturn((Object)publicDocumentAccessEntity);
        this.publicDocumentAccessStorage.removePublicDocumentAccess("123");
        ((PublicDocumentAccessDAO)Mockito.verify((Object)this.publicDocumentAccessDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)publicDocumentAccessEntity);
    }

    @Test
    public void saveDocumentPublicAccess() {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setId(Long.valueOf(0L));
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null, (Object[])new Identity[]{(Identity)Mockito.mock(Identity.class)});
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.publicDocumentAccessStorage.savePublicDocumentAccess(null, 1L));
        Assert.assertEquals((Object)"document access object argument is null", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.publicDocumentAccessStorage.savePublicDocumentAccess(publicDocumentAccess, 1L));
        Assert.assertEquals((Object)"identity is not exist", (Object)exception.getMessage());
        this.publicDocumentAccessStorage.savePublicDocumentAccess(publicDocumentAccess, 1L);
        ((PublicDocumentAccessDAO)Mockito.verify((Object)this.publicDocumentAccessDAO, (VerificationMode)Mockito.times((int)1))).create((Object)((PublicDocumentAccessEntity)Mockito.any()));
        publicDocumentAccess.setId(Long.valueOf(1L));
        this.publicDocumentAccessStorage.savePublicDocumentAccess(publicDocumentAccess, 1L);
        ((PublicDocumentAccessDAO)Mockito.verify((Object)this.publicDocumentAccessDAO, (VerificationMode)Mockito.times((int)1))).update((Object)((PublicDocumentAccessEntity)Mockito.any()));
    }
}

