/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.bulkactions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.BulkStorageActionService;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;

public class ActionThread
implements Runnable {
    private static final Log log = ExoLogger.getLogger(ActionThread.class);
    private static final String ZIP_EXTENSION = ".zip";
    private static final String ZIP_PREFIX = "downloadzip";
    private static final String TEMP_FOLDER_PREFIX = "temp_download";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private final List<AbstractNode> items;
    private final JCRDeleteFileStorage jCrDeleteFileStorage;
    private final DocumentFileStorage documentFileStorage;
    private final BulkStorageActionService bulkStorageActionService;
    private final ListenerService listenerService;
    private final Identity identity;
    private final Long identityId;
    private final Session session;
    private ActionData actionData;
    private String parentPath;
    private Map<String, Object> params;

    public ActionThread(DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jCrDeleteFileStorage, BulkStorageActionService bulkStorageActionService, ListenerService listenerService, ActionData actionData, Map<String, Object> params, Session session, List<AbstractNode> items, Identity identity, Long identityId) {
        this.jCrDeleteFileStorage = jCrDeleteFileStorage;
        this.documentFileStorage = documentFileStorage;
        this.bulkStorageActionService = bulkStorageActionService;
        this.listenerService = listenerService;
        this.actionData = actionData;
        this.params = params;
        this.items = items;
        this.session = session;
        this.identity = identity;
        this.identityId = identityId;
    }

    @Override
    public void run() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.processAction();
        }
        catch (Exception e) {
            log.error("Cannot execute Action {} operation", new Object[]{this.actionData.getActionType(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void processAction() {
        this.actionData = this.bulkStorageActionService.getActionDataById(this.actionData.getActionId());
        if (this.actionData.getActionType().equals(ActionType.DELETE.name())) {
            this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
            this.deleteItems();
        }
        if (this.actionData.getActionType().equals(ActionType.DOWNLOAD.name())) {
            this.downloadItems();
        }
        if (this.actionData.getActionType().equals(ActionType.MOVE.name())) {
            this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
            this.moveItems();
        }
    }

    private void deleteItems() {
        int errors = 0;
        ArrayList<String> treatedItemsIds = new ArrayList<String>();
        for (AbstractNode item : this.items) {
            if (this.checkCanceled()) break;
            try {
                this.jCrDeleteFileStorage.deleteDocument(this.session, item.getPath(), item.getId(), true, true, 0L, this.identity, this.identityId.longValue());
                this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
                treatedItemsIds.add(item.getId());
            }
            catch (PathNotFoundException path) {
                log.error((Object)("The document with this path is not found" + item.getPath()), (Throwable)path);
                ++errors;
            }
            catch (Exception e) {
                log.error((Object)("Error when deleting the document" + item.getPath()), (Throwable)e);
                ++errors;
            }
        }
        if (errors > 0) {
            this.actionData.setStatus(ActionStatus.DONE_WITH_ERRORS.name());
        } else {
            this.actionData.setStatus(ActionStatus.DONE_SUCCSUSSFULLY.name());
        }
        this.actionData.setTreatedItemsIds(treatedItemsIds);
        try {
            this.listenerService.broadcast("bulk_actions_document_event", (Object)this.identity, (Object)this.actionData);
        }
        catch (Exception e) {
            log.error((Object)"cannot broadcast bulk action event");
        }
    }

    private void downloadItems() {
        String tempFolderPath;
        List<Node> nodes = this.items.stream().map(document -> JCRDocumentsUtil.getNodeByIdentifier(this.session, document.getId())).toList();
        try {
            tempFolderPath = Files.createTempDirectory(TEMP_FOLDER_PREFIX, new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            log.error((Object)"Cannot create temp folder to download documents", (Throwable)e);
            return;
        }
        boolean hasFolders = this.items.stream().anyMatch(AbstractNode::isFolder);
        try {
            this.actionData.setStatus(ActionStatus.ZIP_FILE_CREATION.name());
            this.listenerService.broadcast("bulk_actions_document_event", (Object)this.identity, (Object)this.actionData);
        }
        catch (Exception e) {
            log.error((Object)"cannot broadcast bulk action event");
        }
        try {
            for (Node node : nodes) {
                if (this.checkCanceled()) {
                    File folder = new File(tempFolderPath);
                    JCRDocumentsUtil.cleanFiles(folder);
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)this.parentPath)) {
                    this.parentPath = node.getParent().getPath();
                }
                if (hasFolders) {
                    JCRDocumentsUtil.createTempFilesAndFolders(node, "", "", tempFolderPath, this.parentPath);
                    continue;
                }
                JCRDocumentsUtil.createFile(node, "", "", tempFolderPath, this.parentPath);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when creating temp files for download", (Throwable)e);
            this.actionData.setStatus(ActionStatus.FAILED.name());
        }
        String zipName = ZIP_PREFIX + this.actionData.getActionId() + ZIP_EXTENSION;
        String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipName;
        try {
            JCRDocumentsUtil.zipFiles(zipPath, tempFolderPath);
            File zipped = new File(zipPath);
            this.actionData.setDownloadZipPath(zipped.getPath());
            File folder = new File(tempFolderPath);
            JCRDocumentsUtil.cleanFiles(folder);
        }
        catch (Exception e) {
            log.error((Object)"Error when creating zip file", (Throwable)e);
            this.actionData.setStatus(ActionStatus.FAILED.name());
        }
        if (this.checkCanceled()) {
            File zip = new File(zipPath);
            this.deleteFile(zip);
            return;
        }
        if (!this.actionData.getStatus().equals(ActionStatus.FAILED.name())) {
            this.actionData.setStatus(ActionStatus.DONE_SUCCSUSSFULLY.name());
        }
        try {
            this.listenerService.broadcast("bulk_actions_document_event", (Object)this.identity, (Object)this.actionData);
        }
        catch (Exception e) {
            log.error((Object)"cannot broadcast bulk action event");
        }
    }

    private void duplicateItems() {
    }

    private void moveItems() {
        int errors = 0;
        ArrayList<String> treatedItemsIds = new ArrayList<String>();
        for (AbstractNode item : this.items) {
            if (this.checkCanceled()) break;
            try {
                this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
                this.documentFileStorage.moveDocument(this.session, ((Long)this.params.get("ownerId")).longValue(), item.getId(), (String)this.params.get("destPath"), this.identity, "keepBoth");
                treatedItemsIds.add(item.getId());
            }
            catch (Exception e) {
                log.error("Error while moving document {} to path {}", new Object[]{item.getName(), this.params.get("destPath"), e});
                ++errors;
            }
        }
        this.actionData.setTreatedItemsIds(treatedItemsIds);
        if (errors > 0) {
            this.actionData.setStatus(ActionStatus.DONE_WITH_ERRORS.name());
        } else {
            this.actionData.setStatus(ActionStatus.DONE_SUCCSUSSFULLY.name());
        }
        try {
            this.listenerService.broadcast("bulk_actions_document_event", (Object)this.identity, (Object)this.actionData);
        }
        catch (Exception e) {
            log.error((Object)"cannot broadcast bulk action event");
        }
    }

    private boolean checkCanceled() {
        this.actionData = this.bulkStorageActionService.getActionDataById(this.actionData.getActionId());
        if (this.actionData.getStatus().equals(ActionStatus.CANCELED.name())) {
            try {
                this.listenerService.broadcast("bulk_actions_document_event", (Object)this.identity, (Object)this.actionData);
            }
            catch (Exception e) {
                log.error((Object)"cannot broadcast bulk action event");
            }
            return true;
        }
        return false;
    }

    private void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            log.error((Object)"Error while deleting file", (Throwable)e);
        }
    }
}

