/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.bulkactions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.BulkStorageActionService;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadService;

public class ActionThread
implements Runnable {
    private static final Log log = ExoLogger.getLogger(ActionThread.class);
    private static final String ZIP_EXTENSION = ".zip";
    private static final String ZIP_PREFIX = "downloadzip";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_DATA = "jcr:data";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String EXO_TITLE = "exo:title";
    public static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    public static final String JCR_ENCODING = "jcr:encoding";
    public static final String JCR_MIME_TYPE = "jcr:mimeType";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String EXO_NAME = "exo:name";
    public static final String EXO_DATE_CREATED = "exo:dateCreated";
    public static final String EXO_DATE_MODIFIED = "exo:dateModified";
    public static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    public static final String EXO_LAST_MODIFIER = "exo:lastModifier";
    public static final String EXO_MODIFY = "exo:modify";
    public static final String EXO_SORTABLE = "exo:sortable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    private static final MimeTypeResolver mimeTypes = new MimeTypeResolver();
    private long startTime = 0L;
    private final List<AbstractNode> items;
    private final JCRDeleteFileStorage jCrDeleteFileStorage;
    private final DocumentFileStorage documentFileStorage;
    private final BulkStorageActionService bulkStorageActionService;
    private final ListenerService listenerService;
    private final UploadService uploadService;
    private final Long identityId;
    private final Session session;
    private ActionData actionData;
    private String parentPath;
    private String tempFolderPath;
    private Map<String, Object> params;
    private final Node parent;

    public ActionThread(DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jCrDeleteFileStorage, BulkStorageActionService bulkStorageActionService, ListenerService listenerService, UploadService uploadService, ActionData actionData, Node parent, Map<String, Object> params, Session session, List<AbstractNode> items, Long identityId) {
        this.jCrDeleteFileStorage = jCrDeleteFileStorage;
        this.documentFileStorage = documentFileStorage;
        this.bulkStorageActionService = bulkStorageActionService;
        this.uploadService = uploadService;
        this.listenerService = listenerService;
        this.actionData = actionData;
        this.params = params;
        this.items = items;
        this.session = session;
        this.identityId = identityId;
        this.parent = parent;
    }

    @Override
    public void run() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.processAction();
        }
        catch (Exception e) {
            log.error("Cannot execute Action {} operation", new Object[]{this.actionData.getActionType(), e});
            this.actionData.setStatus(ActionStatus.FAILED.name());
            this.brodcastEvent();
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void processAction() throws RepositoryException {
        this.actionData = this.bulkStorageActionService.getActionDataById(this.actionData.getActionId());
        if (this.actionData.getActionType().equals(ActionType.DELETE.name())) {
            this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
            this.deleteItems();
        }
        if (this.actionData.getActionType().equals(ActionType.DOWNLOAD.name())) {
            this.downloadItems();
        }
        if (this.actionData.getActionType().equals(ActionType.MOVE.name())) {
            this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
            this.moveItems();
        }
        if (this.actionData.getActionType().equals(ActionType.IMPORT_ZIP.name())) {
            this.importFromZip();
        }
    }

    private void deleteItems() {
        int errors = 0;
        ArrayList<String> treatedItemsIds = new ArrayList<String>();
        for (AbstractNode item : this.items) {
            if (this.checkCanceled()) break;
            try {
                this.jCrDeleteFileStorage.deleteDocument(this.session, item.getPath(), item.getId(), true, true, 0L, this.actionData.getIdentity(), this.identityId.longValue());
                this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
                treatedItemsIds.add(item.getId());
            }
            catch (PathNotFoundException path) {
                log.error((Object)("The document with this path is not found" + item.getPath()), (Throwable)path);
                ++errors;
            }
            catch (Exception e) {
                log.error((Object)("Error when deleting the document" + item.getPath()), (Throwable)e);
                ++errors;
            }
        }
        if (errors > 0) {
            this.actionData.setStatus(ActionStatus.DONE_WITH_ERRORS.name());
        } else {
            this.actionData.setStatus(ActionStatus.DONE_SUCCESSFULLY.name());
        }
        this.actionData.setTreatedItemsIds(treatedItemsIds);
        this.brodcastEvent();
    }

    private void downloadItems() {
        List<Node> nodes = this.items.stream().map(document -> JCRDocumentsUtil.getNodeByIdentifier(this.session, document.getId())).toList();
        try {
            this.tempFolderPath = Files.createTempDirectory("temp_download", new FileAttribute[0]).toString();
            boolean hasFolders = this.items.stream().anyMatch(AbstractNode::isFolder);
            this.brodcastEvent();
            try {
                for (Node node : nodes) {
                    if (this.checkCanceled()) {
                        File folder = new File(this.tempFolderPath);
                        JCRDocumentsUtil.cleanFiles(folder);
                        break;
                    }
                    if (StringUtils.isEmpty((CharSequence)this.parentPath)) {
                        this.parentPath = node.getParent().getPath();
                    }
                    if (hasFolders) {
                        JCRDocumentsUtil.createTempFilesAndFolders(node, "", "", this.tempFolderPath, this.parentPath);
                        continue;
                    }
                    JCRDocumentsUtil.createFile(node, "", "", this.tempFolderPath, this.parentPath);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error when creating temp files for download", (Throwable)e);
                this.actionData.setStatus(ActionStatus.FAILED.name());
            }
            String zipName = ZIP_PREFIX + this.actionData.getActionId() + ZIP_EXTENSION;
            String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipName;
            try {
                JCRDocumentsUtil.zipFiles(zipPath, this.tempFolderPath);
                File zipped = new File(zipPath);
                this.actionData.setDownloadZipPath(zipped.getPath());
                File folder = new File(this.tempFolderPath);
                JCRDocumentsUtil.cleanFiles(folder);
            }
            catch (Exception e) {
                log.error((Object)"Error when creating zip file", (Throwable)e);
                this.actionData.setStatus(ActionStatus.FAILED.name());
            }
            if (this.checkCanceled()) {
                File zip = new File(zipPath);
                this.deleteFile(zip);
                return;
            }
            if (!this.actionData.getStatus().equals(ActionStatus.FAILED.name())) {
                this.actionData.setStatus(ActionStatus.DONE_SUCCESSFULLY.name());
            }
            this.brodcastEvent();
        }
        catch (IOException e) {
            log.error((Object)"Cannot create temp folder to download documents", (Throwable)e);
        }
    }

    private void duplicateItems() {
    }

    private void moveItems() {
        int errors = 0;
        ArrayList<String> treatedItemsIds = new ArrayList<String>();
        for (AbstractNode item : this.items) {
            if (this.checkCanceled()) break;
            try {
                this.actionData.setStatus(ActionStatus.IN_PROGRESS.name());
                this.documentFileStorage.moveDocument(this.session, ((Long)this.params.get("ownerId")).longValue(), item.getId(), (String)this.params.get("destPath"), this.actionData.getIdentity(), "keepBoth");
                treatedItemsIds.add(item.getId());
            }
            catch (Exception e) {
                log.error("Error while moving document {} to path {}", new Object[]{item.getName(), this.params.get("destPath"), e});
                ++errors;
            }
        }
        this.actionData.setTreatedItemsIds(treatedItemsIds);
        if (errors > 0) {
            this.actionData.setStatus(ActionStatus.DONE_WITH_ERRORS.name());
        } else {
            this.actionData.setStatus(ActionStatus.DONE_SUCCESSFULLY.name());
        }
        this.brodcastEvent();
    }

    private boolean checkCanceled() {
        this.actionData = this.bulkStorageActionService.getActionDataById(this.actionData.getActionId());
        if (this.actionData.getStatus().equals(ActionStatus.CANCELED.name())) {
            this.brodcastEvent();
            return true;
        }
        return false;
    }

    private void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            log.error((Object)"Error while deleting file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromZip() throws RepositoryException {
        try (ZipFile zip = new ZipFile(this.uploadService.getUploadResource(this.actionData.getActionId()).getStoreLocation());){
            this.startTime = System.currentTimeMillis();
            this.actionData.setStatus(ActionStatus.UNZIPPING.name());
            this.brodcastEvent();
            zip.extractAll(this.actionData.getTempFolderPath());
            ArrayList<String> files = new ArrayList<String>();
            this.listFiles(new File(this.actionData.getTempFolderPath()), files);
            this.actionData.setFiles(files);
            this.uploadService.removeUploadResource(this.actionData.getActionId());
            this.actionData.setStatus(ActionStatus.CREATING_DOCUMENTS.name());
            this.brodcastEvent();
            this.createItems();
        }
        catch (IOException e) {
            this.actionData.setStatus(ActionStatus.CANNOT_UNZIP_FILE.name());
            log.error((Object)"Cannot unzip the zip file", (Throwable)e);
            this.brodcastEvent();
        }
        finally {
            this.bulkStorageActionService.removeActionData(this.actionData);
            JCRDocumentsUtil.cleanFiles(new File(this.actionData.getTempFolderPath()));
        }
    }

    private void listFiles(File dir, List<String> files) {
        File[] dirFiles = dir.listFiles();
        if (dirFiles != null && dirFiles.length > 0) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    this.listFiles(file, files);
                    continue;
                }
                files.add(file.getAbsolutePath());
            }
        }
    }

    public void createItems() throws RepositoryException {
        String tempFolderPath = this.actionData.getTempFolderPath();
        HashMap<String, CallSite> folderReplaced = new HashMap<String, CallSite>();
        HashMap<String, Object> folderCreated = new HashMap<String, Object>();
        for (String filePath : this.actionData.getFiles()) {
            try {
                boolean ignored = false;
                File file = new File(filePath);
                filePath = filePath.replace("\\", "/");
                this.actionData.setDocumentInProgress(filePath.replace(tempFolderPath, ""));
                this.brodcastEvent();
                tempFolderPath = tempFolderPath.replace("\\", "/");
                String folderPath = filePath.substring(0, filePath.lastIndexOf("/"));
                folderPath = folderPath.replace(tempFolderPath, "");
                Node folderNode = this.parent;
                if (StringUtils.isNotEmpty((CharSequence)folderPath)) {
                    for (String folderName : folderPath.split("/")) {
                        if (!StringUtils.isNotEmpty((CharSequence)folderName)) continue;
                        String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(folderName));
                        if (folderNode.hasNode(name = URLDecoder.decode(name, StandardCharsets.UTF_8))) {
                            String existingFolderId = folderNode.getNode(name).getUUID();
                            if (this.actionData.getConflict().equals("duplicate")) {
                                if (folderCreated.containsKey(existingFolderId)) {
                                    folderNode = folderNode.getNode((String)folderCreated.get(existingFolderId));
                                    continue;
                                }
                                if (folderReplaced.containsKey(existingFolderId)) {
                                    folderNode = folderNode.getNode((String)folderReplaced.get(existingFolderId));
                                    continue;
                                }
                                int i = 1;
                                String newName = name + " (" + i + ")";
                                String newTitle = folderName + " (" + i + ")";
                                while (folderNode.hasNode(newName)) {
                                    newName = name + " (" + ++i + ")";
                                    newTitle = folderName + " (" + i + ")";
                                }
                                folderReplaced.put(existingFolderId, (CallSite)((Object)newName));
                                Node addedNode = folderNode.addNode(newName, NT_FOLDER);
                                addedNode.setProperty(EXO_TITLE, newTitle);
                                if (addedNode.canAddMixin(MIX_REFERENCEABLE)) {
                                    addedNode.addMixin(MIX_REFERENCEABLE);
                                }
                                folderNode.save();
                                folderNode = folderNode.getNode(newName);
                                folderCreated.put(folderNode.getUUID(), newName);
                                continue;
                            }
                            if (folderCreated.containsKey(existingFolderId)) {
                                folderNode = folderNode.getNode((String)folderCreated.get(existingFolderId));
                                continue;
                            }
                            this.actionData.addIgnoredFile(filePath.replace(tempFolderPath, ""));
                            ignored = true;
                            continue;
                        }
                        Node addedNode = folderNode.addNode(name, NT_FOLDER);
                        addedNode.setProperty(EXO_TITLE, folderName);
                        if (addedNode.canAddMixin(MIX_REFERENCEABLE)) {
                            addedNode.addMixin(MIX_REFERENCEABLE);
                        }
                        folderNode.save();
                        folderNode = folderNode.getNode(name);
                        folderCreated.put(folderNode.getUUID(), name);
                    }
                }
                if (ignored) {
                    this.actionData.incrementImportCount();
                    this.brodcastEvent();
                    continue;
                }
                String title = file.getName();
                String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase()));
                if (!folderNode.hasNode(name = URLDecoder.decode(name, StandardCharsets.UTF_8))) {
                    this.createFile(folderNode, file, name, title);
                    this.actionData.addCreatedFile(filePath.replace(tempFolderPath, ""));
                } else {
                    this.handleImportConflict(file, folderNode, name, title, filePath, tempFolderPath);
                }
            }
            catch (Exception e) {
                log.error("Cannot create file {}", new Object[]{filePath.replace(tempFolderPath, ""), e});
                this.actionData.addFailedFile(filePath.replace(tempFolderPath, ""));
            }
            this.actionData.incrementImportCount();
            this.brodcastEvent();
        }
        this.session.save();
        if (this.actionData.getFailedFiles().size() == this.actionData.getImportedFilesCount()) {
            this.actionData.setStatus(ActionStatus.FAILED.name());
        } else {
            this.actionData.setStatus(ActionStatus.DONE_SUCCESSFULLY.name());
        }
        this.actionData.setDuration(System.currentTimeMillis() - this.startTime);
        this.brodcastEvent();
    }

    public void handleImportConflict(File file, Node folderNode, String name, String title, String filePath, String tempFolderPath) throws Exception {
        if (this.actionData.getConflict().equals("updateAll")) {
            Node existingNode = folderNode.getNode(name);
            this.createNewVersion(existingNode, file);
            this.actionData.addUpdatedFile(filePath.replace(tempFolderPath, ""));
        } else if (this.actionData.getConflict().equals("duplicate")) {
            int i = 1;
            String extension = FilenameUtils.getExtension((String)name);
            String fileBaseName = FilenameUtils.getBaseName((String)name);
            String titleBase = FilenameUtils.getBaseName((String)title);
            String newFileName = fileBaseName + "(" + i + ")." + extension;
            String newFileTitle = titleBase + "(" + i + ")." + extension;
            while (folderNode.hasNode(newFileName)) {
                newFileName = fileBaseName + "(" + ++i + ")." + extension;
                newFileTitle = titleBase + "(" + i + ")." + extension;
            }
            this.createFile(folderNode, file, newFileName, newFileTitle);
            this.actionData.addDuplicatedFile(filePath.replace(tempFolderPath, ""));
        } else {
            this.actionData.addIgnoredFile(filePath.replace(tempFolderPath, ""));
        }
    }

    public void createNewVersion(Node node, File file) throws RepositoryException, IOException {
        if (node.isNodeType(MIX_VERSIONABLE)) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Node destContentNode = node.getNode(JCR_CONTENT);
                destContentNode.setProperty(JCR_DATA, (InputStream)fileInputStream);
                destContentNode.setProperty(JCR_LAST_MODIFIED, Calendar.getInstance());
                if (node.isNodeType(EXO_MODIFY)) {
                    node.setProperty(EXO_DATE_MODIFIED, Calendar.getInstance());
                    node.setProperty(EXO_LAST_MODIFIED_DATE, Calendar.getInstance());
                }
                node.save();
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                node.checkin();
                node.checkout();
                node.getSession().save();
            }
        }
    }

    private void createFile(Node folderNode, File file, String name, String title) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Node fileNode = folderNode.addNode(name, NT_FILE);
            if (!fileNode.isNodeType(EXO_RSS_ENABLE) && fileNode.canAddMixin(EXO_RSS_ENABLE)) {
                fileNode.addMixin(EXO_RSS_ENABLE);
            }
            fileNode.setProperty(EXO_TITLE, title);
            fileNode.setProperty(EXO_NAME, name);
            if (fileNode.canAddMixin(EXO_MODIFY)) {
                fileNode.addMixin(EXO_MODIFY);
            }
            Calendar now = Calendar.getInstance();
            fileNode.setProperty(EXO_DATE_MODIFIED, now);
            fileNode.setProperty(EXO_LAST_MODIFIED_DATE, now);
            fileNode.setProperty(EXO_LAST_MODIFIER, this.actionData.getIdentity().getUserId());
            if (fileNode.canAddMixin(EXO_SORTABLE)) {
                fileNode.addMixin(EXO_SORTABLE);
            }
            if (fileNode.canAddMixin(MIX_VERSIONABLE)) {
                fileNode.addMixin(MIX_VERSIONABLE);
            }
            Node jcrContent = fileNode.addNode(JCR_CONTENT, NT_RESOURCE);
            jcrContent.setProperty(JCR_DATA, (InputStream)fileInputStream);
            jcrContent.setProperty(JCR_LAST_MODIFIED, Calendar.getInstance());
            jcrContent.setProperty(JCR_ENCODING, "UTF-8");
            String mimeType = mimeTypes.getMimeType(file.getName());
            jcrContent.setProperty(JCR_MIME_TYPE, mimeType);
            folderNode.save();
        }
    }

    private void brodcastEvent() {
        try {
            this.listenerService.broadcast("bulk_actions_document_event", (Object)this.actionData.getIdentity(), (Object)this.actionData);
        }
        catch (Exception e) {
            log.error((Object)"cannot broadcast bulk action event");
        }
    }
}

