/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.listener;

import io.meeds.social.category.model.CategoryObject;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryLinkModifiedDocumentListener
implements ListenerBase<Long, CategoryObject> {
    public static final String OBJECT_TYPE = "document";
    @Autowired
    private DocumentFileService documentFileService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private SessionProviderService sessionProviderService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("category.link.added", (ListenerBase)this);
        this.listenerService.addListener("category.link.removed", (ListenerBase)this);
    }

    public void onEvent(Event<Long, CategoryObject> event) throws Exception {
        CategoryObject object = (CategoryObject)event.getData();
        String type = object.getType();
        if (OBJECT_TYPE.equals(type)) {
            ManageableRepository repository;
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session systemSession = sessionProvider.getSession((repository = this.repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), repository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, object.getId());
            if (node == null) {
                return;
            }
            List categoryIds = this.documentFileService.getDocumentCategoryIds(object.getId());
            String[] newCategoryIds = (String[])categoryIds.stream().map(String::valueOf).toArray(String[]::new);
            if (node.canAddMixin("mix:documentsCategory")) {
                node.addMixin("mix:documentsCategory");
            }
            boolean modified = true;
            if (node.hasProperty("exo:categoryIds")) {
                Value[] existingValues = node.getProperty("exo:categoryIds").getValues();
                List existingIdsList = Arrays.stream(existingValues).map(v -> {
                    try {
                        return v.getString();
                    }
                    catch (RepositoryException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                boolean bl = modified = CollectionUtils.size(existingIdsList) != CollectionUtils.size((Object)categoryIds) || !categoryIds.isEmpty() && !CollectionUtils.isEqualCollection(Collections.singleton(categoryIds), existingIdsList);
            }
            if (modified) {
                node.setProperty("exo:categoryIds", newCategoryIds);
                node.save();
                systemSession.save();
            }
        }
    }
}

