/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.documents.storage.jcr.util.ACLProperties;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class PathCommandHandler {
    public static final List<QName> PROPERTY_NAMES = Arrays.asList(PropertyConstants.VERSIONNAME, PropertyConstants.VERSIONHISTORY, PropertyConstants.DISPLAYNAME, PropertyConstants.CHECKEDIN, PropertyConstants.CHECKEDOUT, PropertyConstants.PREDECESSORSET, PropertyConstants.SUCCESSORSET, PropertyConstants.RESOURCETYPE, PropertyConstants.GETCONTENTLENGTH, PropertyConstants.GETCONTENTTYPE, PropertyConstants.CREATIONDATE, PropertyConstants.GETLASTMODIFIED, PropertyConstants.GET_ETAG, PropertyConstants.CHILDCOUNT, PropertyConstants.HASCHILDREN, PropertyConstants.ISCOLLECTION, PropertyConstants.ISFOLDER, PropertyConstants.ISROOT, PropertyConstants.PARENTNAME, PropertyConstants.SUPPORTEDLOCK, PropertyConstants.LOCKDISCOVERY, PropertyConstants.ISVERSIONED, PropertyConstants.SUPPORTEDMETHODSET, ACLProperties.ACL, PropertyConstants.OWNER);
    public static final String IDENTITY_PATHS_FORMAT = "%s/%s%s%s%s";
    public static final String PATHS_CONCAT_FORMAT = "%s/%s";
    protected static final Log LOG = ExoLogger.getLogger(PathCommandHandler.class);
    private static final String WEBDAV_IDENTITY_JCR_PATH_CACHE_NAME = "webdav.identityJcrBasePath";
    private static final String WEBDAV_IDENTITY_ID_PATH_CACHE_NAME = "webdav.identityIdByPath";
    private static final String WEBDAV_JCR_PATH_CACHE_NAME = "webdav.jcrPathByWebDavPath";
    private static final String GROUPS_PATH = "groupsPath";
    private static final String USERS_PATH = "usersPath";
    @Autowired
    protected IdentityManager identityManager;
    @Autowired
    protected SpaceService spaceService;
    @Autowired
    protected NodeHierarchyCreator nodeHierarchyCreator;
    @Autowired
    protected SessionProviderService sessionProviderService;
    private String usersJcrBasePath;
    private String groupsJcrBasePath;

    @Cacheable(value={"webdav.identityJcrBasePath"})
    public String getIdentityBaseJcrPath(String webDavPath) {
        Long identityId = this.getIdentityIdFromWebDavPath(webDavPath);
        if (identityId == null) {
            throw new WebDavException(404, String.format("Can't read identity id from path: %s", webDavPath));
        }
        return this.getIdentityBaseJcrPath(identityId);
    }

    @Cacheable(value={"webdav.identityJcrBasePath"})
    public String getIdentityBaseJcrPath(long identityId) {
        Identity identity = this.identityManager.getIdentity(identityId);
        if (identity == null) {
            throw new WebDavException(404, String.format("Identity with id %s not found", identityId));
        }
        if (identity.isUser()) {
            SessionProvider systemSessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Node userNode = this.nodeHierarchyCreator.getUserNode(systemSessionProvider, identity.getRemoteId());
            Node userPrivateNode = userNode.getNode("Private");
            return userPrivateNode.getPath();
        }
        if (identity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
            if (space == null) {
                throw new WebDavException(404, String.format("Space with pretty name %s not found", identity.getRemoteId()));
            }
            return String.format("%s%s/Documents", this.getGroupsBaseJcrPath(), space.getGroupId());
        }
        throw new WebDavException(400, String.format("Identity with type %s not supported", identity.getProviderId()));
    }

    @Cacheable(value={"webdav.identityIdByPath"})
    public Long getIdentityIdFromJcrPath(String jcrPath, String username) {
        if (jcrPath.startsWith(this.getGroupsBaseJcrPath() + "/spaces")) {
            String[] pathParts = jcrPath.replaceFirst(this.getGroupsBaseJcrPath() + "/spaces", "").split("/");
            String spaceGroupId = String.format("/spaces/%s", StringUtils.firstNonBlank((CharSequence[])new String[]{pathParts[0], pathParts[1]}));
            Space space = this.spaceService.getSpaceByGroupId(spaceGroupId);
            Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            return spaceIdentity.getIdentityId();
        }
        if (jcrPath.startsWith(this.getUsersBaseJcrPath()) && jcrPath.contains(String.format("/%s/", username))) {
            Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
            return userIdentity.getIdentityId();
        }
        return null;
    }

    @Cacheable(value={"webdav.identityIdByPath"})
    public Long getIdentityIdFromWebDavPath(String webDavPath) {
        if (StringUtils.isBlank((CharSequence)webDavPath) || StringUtils.equals((CharSequence)webDavPath, (CharSequence)"/")) {
            return null;
        }
        String[] pathParts = webDavPath.split("/");
        String identityPart = Arrays.stream(pathParts).filter(StringUtils::isNotBlank).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).findFirst().orElse(null);
        String identityId = null;
        if (identityPart != null && identityPart.endsWith(")") && identityPart.contains("(")) {
            identityId = identityPart.substring(identityPart.lastIndexOf("(") + 1, identityPart.lastIndexOf(")"));
        }
        if (identityId != null) {
            return Long.parseLong(identityId);
        }
        return null;
    }

    @Cacheable(value={"webdav.jcrPathByWebDavPath"})
    public String transformToJcrPath(String webDavPath) {
        Long identityId = this.getIdentityIdFromWebDavPath(webDavPath);
        if (identityId == null) {
            return "/";
        }
        String identityRelativeJcrPath = this.getIdentityRelativeJcrPath(webDavPath);
        if (StringUtils.isBlank((CharSequence)identityRelativeJcrPath)) {
            return this.getIdentityBaseJcrPath(identityId);
        }
        return String.format(PATHS_CONCAT_FORMAT, this.getIdentityBaseJcrPath(identityId), identityRelativeJcrPath);
    }

    public boolean isIdentityRootWebDavPath(String webDavPath) {
        String identityRelativeJcrPath = this.getIdentityRelativeJcrPath(webDavPath);
        return StringUtils.isBlank((CharSequence)identityRelativeJcrPath);
    }

    private String getIdentityRelativeJcrPath(String webDavPath) {
        String[] pathParts = webDavPath.split("/");
        return Arrays.stream(pathParts).filter(StringUtils::isNotBlank).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).map(Utils::encodeNodeName).skip(1L).collect(Collectors.joining("/"));
    }

    private String getGroupsBaseJcrPath() {
        if (this.groupsJcrBasePath == null) {
            this.groupsJcrBasePath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        }
        return this.groupsJcrBasePath;
    }

    private String getUsersBaseJcrPath() {
        if (this.usersJcrBasePath == null) {
            this.usersJcrBasePath = this.nodeHierarchyCreator.getJcrPath(USERS_PATH);
        }
        return this.usersJcrBasePath;
    }
}

