/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.documents.storage.TrashStorage;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.documents.storage.jcr.webdav.plugin.PathCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItemOrder;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.WebDavLockResponse;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.stereotype.Component;

@Component
public class WebdavWriteCommandHandler {
    protected static final Log LOG = ExoLogger.getLogger(WebdavWriteCommandHandler.class);
    private static final Set<QName> READ_ONLY_PROPS = Collections.singleton(PropertyConstants.JCR_DATA);
    private static final Set<QName> NON_REMOVING_PROPS = new HashSet<QName>(Arrays.asList(PropertyConstants.CREATIONDATE, PropertyConstants.DISPLAYNAME, PropertyConstants.GETCONTENTLANGUAGE, PropertyConstants.GETCONTENTLENGTH, PropertyConstants.GETCONTENTTYPE, PropertyConstants.GETLASTMODIFIED, PropertyConstants.JCR_DATA));
    private static final String RESOURCE_WITH_PATH_S_NOT_FOUND = "Resource with path '%s' not found";
    private static final Context LOCK_CONTEXT = Context.GLOBAL.id("WebDav");
    private static final Scope LOCK_SCOPE = Scope.APPLICATION.id("WebDavLock");
    private MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
    private RepositoryService repositoryService;
    private TrashStorage trashStorage;
    private SessionProviderService sessionProviderService;
    private SettingService settingService;
    private PathCommandHandler pathCommandHandler;

    public WebdavWriteCommandHandler(SessionProviderService sessionProviderService, RepositoryService repositoryService, TrashStorage trashStorage, SettingService settingService, PathCommandHandler pathCommandHandler) {
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.trashStorage = trashStorage;
        this.settingService = settingService;
        this.pathCommandHandler = pathCommandHandler;
    }

    @PostConstruct
    public void init() {
        this.mimeTypeResolver.setDefaultMimeType("application/octet-stream");
    }

    public void createFolder(Session session, String webDavPath, List<String> mixinTypes) {
        this.checkNotRoot(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        Node node = this.addNode(session, jcrPath, "nt:folder");
        this.addMixins(node, mixinTypes);
        session.save();
    }

    public void saveFile(Session session, String webDavPath, String mediaType, List<String> mixinTypes, InputStream inputStream) {
        this.checkNotRoot(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        Node node = session.itemExists(jcrPath) ? (Node)session.getItem(jcrPath) : null;
        Calendar now = Calendar.getInstance();
        if (node == null) {
            node = this.addNode(session, jcrPath, "nt:file");
            if (!node.hasNode("jcr:content")) {
                Node content = node.addNode("jcr:content", "nt:resource");
                content.setProperty("jcr:lastModified", now);
            }
            if (node.canAddMixin("mix:versionable")) {
                node.addMixin("mix:versionable");
            }
            if (node.canAddMixin("exo:sortable")) {
                node.addMixin("exo:sortable");
            }
            node.setProperty("exo:name", node.getName());
            node.setProperty("exo:title", node.getName());
        } else {
            this.forceUnlock(node);
            VersionHistoryUtils.createVersion((Node)node);
        }
        this.updateContent(node, mediaType, inputStream);
        this.addMixins(node, mixinTypes);
        session.save();
    }

    public Map<String, Collection<WebDavItemProperty>> saveProperties(Session session, String webDavPath, List<WebDavItemProperty> propertiesToSave, List<WebDavItemProperty> propertiesToRemove) throws WebDavException {
        Collection propSet;
        WebDavItemProperty jcrContentProp;
        Collection propSet2;
        Object statname;
        int i;
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = (Node)session.getItem(jcrPath);
        HashMap<String, Collection<WebDavItemProperty>> result = new HashMap<String, Collection<WebDavItemProperty>>();
        for (i = 0; i < propertiesToSave.size(); ++i) {
            WebDavItemProperty property = propertiesToSave.get(i);
            statname = org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)200);
            try {
                if (property.getStringName().equals("jcr:content")) {
                    for (WebDavItemProperty child : property.getChildren()) {
                        if (!child.getChildren().isEmpty()) continue;
                        if (node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
                            node.checkout();
                            node.save();
                        }
                        Node content = node.getNode("jcr:content");
                        statname = this.setProperty(content, child);
                        propSet2 = result.computeIfAbsent((String)statname, k -> new HashSet());
                        jcrContentProp = new WebDavItemProperty(PropertyConstants.JCR_CONTENT);
                        jcrContentProp.addChild(new WebDavItemProperty(child.getName()));
                        propSet2.add(jcrContentProp);
                    }
                    continue;
                }
                statname = this.setProperty(node, property);
                propSet = result.computeIfAbsent((String)statname, k -> new HashSet());
                propSet.add(new WebDavItemProperty(property.getName()));
                continue;
            }
            catch (RepositoryException e) {
                statname = org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)409);
                Collection propSet3 = result.computeIfAbsent((String)statname, k -> new HashSet());
                propSet3.add(new WebDavItemProperty(property.getName()));
            }
        }
        for (i = 0; i < propertiesToRemove.size(); ++i) {
            WebDavItemProperty removeProperty = propertiesToRemove.get(i);
            if (NON_REMOVING_PROPS.contains(removeProperty.getName())) {
                statname = org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)409);
                propSet = result.computeIfAbsent((String)statname, k -> new HashSet());
                propSet.add(new WebDavItemProperty(removeProperty.getName()));
                continue;
            }
            if (removeProperty.getStringName().equals("jcr:content")) {
                for (WebDavItemProperty child : removeProperty.getChildren()) {
                    Node content = node.getNode("jcr:content");
                    String statname2 = this.removeProperty(content, child);
                    propSet2 = result.computeIfAbsent(statname2, k -> new HashSet());
                    jcrContentProp = new WebDavItemProperty(new QName("jcr:content"));
                    jcrContentProp.addChild(new WebDavItemProperty(child.getName()));
                    propSet2.add(jcrContentProp);
                }
                continue;
            }
            statname = this.removeProperty(node, removeProperty);
            propSet = result.computeIfAbsent((String)statname, k -> new HashSet());
            propSet.add(new WebDavItemProperty(removeProperty.getName()));
        }
        return result;
    }

    public void delete(Session session, String webDavPath) throws WebDavException {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = (Node)session.getItem(jcrPath);
        this.forceUnlock(node);
        if (!this.canRemoveNode(node)) {
            throw new WebDavException(403, String.format("Resource with path '%s' can't be removed", jcrPath));
        }
        this.trashStorage.moveToTrash(node, new SessionProvider(((SessionImpl)session).getUserState()));
        session.save();
    }

    public boolean move(Session session, String webDavSourcePath, String webDavTargetPath, boolean overwrite) throws WebDavException {
        this.checkNotReadOnly(webDavSourcePath);
        this.checkNotRoot(webDavTargetPath);
        String sourceJcrPath = this.pathCommandHandler.transformToJcrPath(webDavSourcePath);
        String targetJcrPath = this.pathCommandHandler.transformToJcrPath(webDavTargetPath);
        this.checkResourceExists(session, sourceJcrPath);
        boolean itemExists = session.itemExists(targetJcrPath);
        if (itemExists) {
            if (overwrite) {
                Node targetNodeToremove = (Node)session.getItem(targetJcrPath);
                targetNodeToremove.remove();
                session.save();
            } else {
                throw new WebDavException(409, String.format("Resource with path '%s' already exists", targetJcrPath));
            }
        }
        this.forceUnlock((Node)session.getItem(sourceJcrPath));
        session.move(sourceJcrPath, targetJcrPath);
        session.save();
        Node targetNode = (Node)session.getItem(targetJcrPath);
        if (targetNode.isNodeType("exo:sortable")) {
            targetNode.setProperty("exo:name", targetNode.getName());
            targetNode.setProperty("exo:title", targetNode.getName());
            session.save();
        }
        return itemExists;
    }

    public void copy(Session session, String webDavSourcePath, String webDavTargetPath, boolean overwrite, boolean removeDestination) throws WebDavException {
        this.checkNotRoot(webDavSourcePath);
        this.checkNotRoot(webDavTargetPath);
        String sourceJcrPath = this.pathCommandHandler.transformToJcrPath(webDavSourcePath);
        String targetJcrPath = this.pathCommandHandler.transformToJcrPath(webDavTargetPath);
        this.checkResourceExists(session, sourceJcrPath);
        boolean itemExists = session.itemExists(targetJcrPath);
        if (itemExists && removeDestination) {
            Item destItem = session.getItem(targetJcrPath);
            destItem.remove();
            session.save();
        } else if (itemExists && !overwrite) {
            throw new WebDavException(409, String.format("Resource with path '%s' already exists", targetJcrPath));
        }
        Workspace workspace = session.getWorkspace();
        workspace.copy(sourceJcrPath, targetJcrPath);
    }

    public void enableVersioning(Session session, String webDavPath) {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = (Node)session.getItem(jcrPath);
        this.forceUnlock(node);
        if (!node.isNodeType("mix:versionable")) {
            node.addMixin("mix:versionable");
            session.save();
        }
    }

    public void checkin(Session session, String webDavPath) {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)jcrPath));
        this.forceUnlock(node);
        node.checkin();
    }

    public void checkout(Session session, String webDavPath) throws WebDavException {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)jcrPath));
        node.checkout();
    }

    public void uncheckout(Session session, String webDavPath) throws WebDavException {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)jcrPath));
        Version restoreVersion = node.getBaseVersion();
        node.restore(restoreVersion, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebDavLockResponse lock(Session session, String webDavPath, int depth, int lockTimeout, boolean bodyIsEmpty, String username) {
        Lock lock;
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = (Node)session.getItem(jcrPath);
        if (!node.isNodeType("mix:lockable") && node.canAddMixin("mix:lockable")) {
            node.addMixin("mix:lockable");
            session.save();
        }
        if (node.isLocked()) {
            lock = node.getLock();
            String lockOwner = lock.getLockOwner();
            if (!StringUtils.equals((CharSequence)lockOwner, (CharSequence)username)) throw new WebDavException(423, String.format("Resource with path '%s' is already locked by a different owner %s", jcrPath, lockOwner));
            lock.refresh();
        } else {
            lock = node.lock(depth > 1, false);
        }
        this.saveLockTimeout(jcrPath, lockTimeout);
        return new WebDavLockResponse(lock.getLockToken(), username);
    }

    public void unlock(Session session, String webDavPath, List<String> lockTokens) {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        try {
            this.unlockNode(session, jcrPath);
        }
        catch (Exception e) {
            if (CollectionUtils.isNotEmpty(lockTokens)) {
                lockTokens.forEach(t -> this.unlockNode(session, jcrPath, (String)t));
            }
        }
    }

    public void unlockNode(Session session, String jcrPath) {
        Node node;
        if (session.itemExists(jcrPath) && (node = (Node)session.getItem(jcrPath)).isLocked()) {
            node.unlock();
            session.save();
        }
        this.removeLockTimeout(jcrPath);
    }

    public boolean order(Session session, String webDavPath, List<WebDavItemOrder> members) throws WebDavException {
        this.checkNotReadOnly(webDavPath);
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        this.checkResourceExists(session, jcrPath);
        Node node = (Node)session.getItem(jcrPath);
        for (int i = 0; i < members.size(); ++i) {
            int status;
            WebDavItemOrder member = members.get(i);
            try {
                if (node.hasNode(member.getSegment())) {
                    if (new QName("DAV:", "last").equals(member.getPosition())) {
                        status = 200;
                    } else {
                        String positionedNodeName = this.getPositionnedNode(node, member);
                        if (positionedNodeName != null) {
                            session.refresh(false);
                            node.orderBefore(member.getSegment(), positionedNodeName);
                            session.save();
                            status = 200;
                        } else {
                            status = 404;
                        }
                    }
                } else {
                    status = 404;
                }
            }
            catch (LockException e) {
                status = 423;
            }
            catch (PathNotFoundException e) {
                status = 404;
            }
            catch (AccessDeniedException e) {
                status = 403;
            }
            catch (RepositoryException e) {
                status = 500;
                LOG.warn("Error while ordering member '{}' inside path '{}'. Continue ordering other items.", new Object[]{member, e});
            }
            member.setStatus(status);
        }
        return members.stream().allMatch(m -> m.getStatus() == 200);
    }

    public void removeLockTimeout(String path) {
        this.settingService.remove(LOCK_CONTEXT, LOCK_SCOPE, path);
    }

    public void saveLockTimeout(String path, long lockTimeout) {
        this.settingService.set(LOCK_CONTEXT, LOCK_SCOPE, path, SettingValue.create((String)String.valueOf(System.currentTimeMillis() + lockTimeout * 1000L)));
    }

    public List<String> getOutdatedLockedNodePaths() {
        Map locks;
        Map settings = this.settingService.getSettingsByContext(LOCK_CONTEXT);
        Map map = locks = MapUtils.isEmpty((Map)settings) ? Collections.emptyMap() : (Map)settings.get(LOCK_SCOPE);
        if (MapUtils.isNotEmpty((Map)locks)) {
            return locks.entrySet().stream().filter(e -> Long.parseLong((String)((SettingValue)e.getValue()).getValue()) < System.currentTimeMillis()).map(Map.Entry::getKey).toList();
        }
        return Collections.emptyList();
    }

    private void checkNotReadOnly(String webDavPath) throws WebDavException {
        this.checkNotRoot(webDavPath);
        this.checkNotIdentityRoot(webDavPath);
    }

    private void checkNotRoot(String webDavPath) throws WebDavException {
        if (StringUtils.isBlank((CharSequence)webDavPath) || "/".equals(webDavPath)) {
            throw new WebDavException(403, String.format("Resource with path '%s' is in ReadOnly state", webDavPath));
        }
    }

    private void checkNotIdentityRoot(String webDavPath) throws WebDavException {
        if (this.pathCommandHandler.isIdentityRootWebDavPath(webDavPath)) {
            throw new WebDavException(403, String.format("Resource with path '%s' is in ReadOnly state", webDavPath));
        }
    }

    private void checkResourceExists(Session session, String jcrPath) throws RepositoryException, WebDavException {
        if (!session.itemExists(jcrPath)) {
            throw new WebDavException(404, String.format(RESOURCE_WITH_PATH_S_NOT_FOUND, jcrPath));
        }
    }

    private void updateContent(Node node, String mediaType, InputStream inputStream) throws RepositoryException {
        String resolvedMimeType;
        String path = node.getPath();
        Node content = node.getNode("jcr:content");
        String encoding = null;
        if (StringUtils.contains((CharSequence)mediaType, (CharSequence)";")) {
            String[] mediaTypeParts = mediaType.split(";");
            encoding = mediaTypeParts[1].replace("charset", "").replace("=", "").replace("\"", "").toUpperCase().trim();
            mediaType = mediaTypeParts[0].trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(resolvedMimeType = this.mimeTypeResolver.getMimeType(node.getName()))) && !StringUtils.equals((CharSequence)resolvedMimeType, (CharSequence)this.mimeTypeResolver.getDefaultMimeType())) {
            this.handleJcrOperation(() -> content.setProperty("jcr:mimeType", resolvedMimeType), path);
        } else {
            String mediaTypeConstant = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{mediaType, this.mimeTypeResolver.getDefaultMimeType()});
            this.handleJcrOperation(() -> content.setProperty("jcr:mimeType", mediaTypeConstant), path);
        }
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            String encodingConstant = encoding;
            this.handleJcrOperation(() -> content.setProperty("jcr:encoding", encodingConstant), path);
        }
        this.handleJcrOperation(() -> content.setProperty("jcr:lastModified", Calendar.getInstance()), path);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
        this.handleJcrOperation(() -> content.setProperty("jcr:data", (InputStream)byteArrayInputStream), path);
    }

    private Node addNode(Session session, String jcrPath, String nodeType) {
        List<String> pathParts = Arrays.stream(jcrPath.split("/")).filter(StringUtils::isNotBlank).toList();
        String name = pathParts.getLast();
        String parentPath = StringUtils.join(pathParts.subList(0, pathParts.size() - 1), (String)"/");
        return ((Node)session.getItem("/" + parentPath)).addNode(Utils.encodeNodeName(name), nodeType);
    }

    private void addMixins(Node node, List<String> mixinTypes) {
        if (CollectionUtils.isNotEmpty(mixinTypes)) {
            for (int i = 0; i < mixinTypes.size(); ++i) {
                String mixinType = mixinTypes.get(i);
                if (node.canAddMixin(mixinType)) {
                    node.addMixin(mixinType);
                    continue;
                }
                LOG.warn("Can't add mixin '{}' in node '{}'. Ignore it.", new Object[]{mixinType, node.getPath()});
            }
        }
    }

    private String getPositionnedNode(Node node, WebDavItemOrder member) {
        NodeIterator nodeIter = node.getNodes();
        Node previousNode = null;
        while (nodeIter.hasNext()) {
            Node currentNode = nodeIter.nextNode();
            if (new QName("DAV:", "first").equals(member.getPosition())) {
                return currentNode.getName();
            }
            if (new QName("DAV:", "before").equals(member.getPosition()) && previousNode != null && currentNode.getName().equals(member.getPositionSegment())) {
                return previousNode.getName();
            }
            if (new QName("DAV:", "after").equals(member.getPosition()) && currentNode.getName().equals(member.getPositionSegment()) && nodeIter.hasNext()) {
                return nodeIter.nextNode().getName();
            }
            previousNode = currentNode;
        }
        return null;
    }

    private String setProperty(Node node, WebDavItemProperty property) {
        String propertyName = WebDavNamespaceContext.createName((QName)property.getName());
        if (READ_ONLY_PROPS.contains(property.getName())) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)409);
        }
        try {
            Workspace ws = node.getSession().getWorkspace();
            NodeTypeDataManager nodeTypeHolder = ((WorkspaceImpl)ws).getNodeTypesHolder();
            NodeData data = (NodeData)((NodeImpl)node).getData();
            InternalQName propName = ((SessionImpl)node.getSession()).getLocationFactory().parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas propdefs = nodeTypeHolder.getPropertyDefinitions(propName, data.getPrimaryTypeName(), data.getMixinTypeNames());
            if (propdefs == null) {
                throw new ItemNotFoundException();
            }
            PropertyDefinitionData propertyDefinitionData = propdefs.getAnyDefinition();
            if (propertyDefinitionData == null) {
                throw new ItemNotFoundException();
            }
            boolean isMultiValued = propertyDefinitionData.isMultiple();
            if (node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
                node.checkout();
                node.save();
            }
            if (!isMultiValued) {
                node.setProperty(propertyName, property.getValue());
            } else {
                String[] value = new String[]{property.getValue()};
                node.setProperty(propertyName, value);
            }
            node.save();
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)200);
        }
        catch (AccessDeniedException e) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)403);
        }
        catch (RepositoryException e) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)404);
        }
        catch (Exception e) {
            LOG.warn("Error while setting property '{}' value. Continue settings other properties", new Object[]{property.getName(), e});
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)404);
        }
    }

    private String removeProperty(Node node, WebDavItemProperty property) {
        try {
            node.getProperty(property.getStringName()).remove();
            node.save();
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)200);
        }
        catch (AccessDeniedException e) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)403);
        }
        catch (ItemNotFoundException | PathNotFoundException e) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)404);
        }
        catch (RepositoryException e) {
            return org.exoplatform.documents.webdav.model.constant.PropertyConstants.getStatusDescription((int)409);
        }
    }

    private void unlockNode(Session session, String path, String token) {
        try {
            session.removeLockToken(token);
            this.removeLockTimeout(path);
        }
        catch (Exception ex) {
            LOG.warn("Can't unlock file '{}'. Attempt to force unlocking", new Object[]{path, ex});
            Node node = (Node)session.getItem(path);
            this.forceUnlock(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceUnlock(Node node) {
        if (node.isLocked()) {
            try {
                node.unlock();
                node.getSession().save();
            }
            catch (Exception e) {
                SessionProvider systemSessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repositoryService.getDefaultRepository();
                Session systemSession = systemSessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                try {
                    Node nodeWithSystemSession = (Node)systemSession.getItem(node.getPath());
                    nodeWithSystemSession.unlock();
                    systemSession.save();
                }
                finally {
                    systemSession.logout();
                    node.getSession().refresh(false);
                }
            }
            this.removeLockTimeout(node.getPath());
            return true;
        }
        return false;
    }

    private boolean canRemoveNode(Node node) {
        return this.checkPermission(node, "remove");
    }

    private boolean checkPermission(Node node, String permissionType) {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private void handleJcrOperation(RunnableWithException r, String path) {
        try {
            r.run();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Unknown Error occurred while updating File '{}' Data. Continue storing file", new Object[]{path, e});
        }
    }

    @FunctionalInterface
    public static interface RunnableWithException {
        public void run() throws RepositoryException;
    }
}

