/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.version.Version;
import org.exoplatform.documents.storage.TrashStorage;
import org.exoplatform.documents.storage.jcr.webdav.plugin.PathCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavWriteCommandHandler;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.security.ConversationState;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class WebdavWriteCommandHandlerTest {
    private static final String JCR_PATH = "/jcr/path";
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private TrashStorage trashStorage;
    @Mock
    private PathCommandHandler pathCommandHandler;
    @Mock
    private SessionImpl session;
    @Mock
    private NodeImpl node;
    @Mock
    private ConversationState conversationState;
    @Mock
    private Node destNode;
    @Mock
    private Lock lock;
    @Mock
    private Version version;
    @InjectMocks
    private WebdavWriteCommandHandler handler;

    @Before
    public void setUp() {
        Mockito.when((Object)this.pathCommandHandler.transformToJcrPath(ArgumentMatchers.anyString())).thenReturn((Object)JCR_PATH);
        Mockito.when((Object)this.session.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.session.getItem(JCR_PATH)).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)JCR_PATH);
        Mockito.when((Object)this.node.getName()).thenReturn((Object)Arrays.asList(JCR_PATH.split("/")).getLast());
    }

    @Test
    public void testSaveFile() {
        Mockito.when((Object)this.node.addNode("file", "nt:file")).thenReturn((Object)this.destNode);
        Mockito.when((Object)this.destNode.addNode("jcr:content", "nt:resource")).thenReturn((Object)this.destNode);
        Mockito.when((Object)this.destNode.setProperty((String)ArgumentMatchers.eq((Object)"jcr:data"), (InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(null);
        this.handler.saveFile((Session)this.session, JCR_PATH, "text/plain", Collections.emptyList(), (InputStream)new ByteArrayInputStream("data".getBytes()));
        ((SessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.atLeastOnce())).save();
    }

    @Test
    public void testDelete() {
        Mockito.when((Object)this.session.getUserState()).thenReturn((Object)this.conversationState);
        this.handler.delete((Session)this.session, JCR_PATH);
        ((TrashStorage)Mockito.verify((Object)this.trashStorage)).moveToTrash((Node)ArgumentMatchers.eq((Object)this.node), (SessionProvider)ArgumentMatchers.any(SessionProvider.class));
        ((SessionImpl)Mockito.verify((Object)this.session)).save();
    }

    @Test
    public void testEnableVersioning() {
        Mockito.when((Object)this.node.isNodeType("mix:versionable")).thenReturn((Object)false);
        this.handler.enableVersioning((Session)this.session, JCR_PATH);
        ((NodeImpl)Mockito.verify((Object)this.node)).addMixin("mix:versionable");
        ((SessionImpl)Mockito.verify((Object)this.session)).save();
    }
}

