/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache.listener;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.documents.storage.jcr.webdav.cache.CachedJcrWebDavService;
import org.exoplatform.documents.storage.jcr.webdav.cache.listener.WebDavCacheUpdaterAction;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDavCacheUpdaterActionTest {
    private static final String FILE_PATH = "/Users/john/file.txt";
    @Mock
    private CachedJcrWebDavService cachedService;
    @Mock
    private EventIterator eventIterator;
    @Mock
    private Event event;
    @InjectMocks
    private WebDavCacheUpdaterAction action;

    @Before
    public void setUp() {
        Mockito.when((Object)this.eventIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.eventIterator.nextEvent()).thenReturn((Object)this.event);
    }

    @Test
    public void testOnEventNodeAddedDropTrue() {
        Mockito.when((Object)this.event.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.event.getPath()).thenReturn((Object)"/Groups/spaces/mySpace");
        this.action.onEvent(this.eventIterator);
        ((CachedJcrWebDavService)Mockito.verify((Object)this.cachedService)).clearCache("/Groups/spaces/mySpace", true);
    }

    @Test
    public void testOnEventNodeRemovedWithJcrContent() {
        Mockito.when((Object)this.event.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.event.getPath()).thenReturn((Object)"/Users/john/jcr:content");
        this.action.onEvent(this.eventIterator);
        ((CachedJcrWebDavService)Mockito.verify((Object)this.cachedService)).clearCache("/Users/john", true);
    }

    @Test
    public void testOnEventPropertyChangedNoDrop() {
        Mockito.when((Object)this.event.getType()).thenReturn((Object)16);
        Mockito.when((Object)this.event.getPath()).thenReturn((Object)"/Users/john/file.txt/jcr:data");
        this.action.onEvent(this.eventIterator);
        ((CachedJcrWebDavService)Mockito.verify((Object)this.cachedService)).clearCache(FILE_PATH, false);
    }

    @Test
    public void testOnEventExceptionInClearCache() {
        Mockito.when((Object)this.event.getType()).thenReturn((Object)0x2000000);
        Mockito.when((Object)this.event.getPath()).thenReturn((Object)FILE_PATH);
        ((CachedJcrWebDavService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("fail")}).when((Object)this.cachedService)).clearCache(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.action.onEvent(this.eventIterator);
        ((CachedJcrWebDavService)Mockito.verify((Object)this.cachedService)).clearCache(FILE_PATH, true);
    }

    @Test
    public void testGetCachedJcrWebDavServiceFallbackToContainer() {
        WebDavCacheUpdaterAction actionNoService = new WebDavCacheUpdaterAction(null);
        CachedJcrWebDavService mockService = (CachedJcrWebDavService)Mockito.mock(CachedJcrWebDavService.class);
        try (MockedStatic mockedCtx = Mockito.mockStatic(ExoContainerContext.class);){
            mockedCtx.when(() -> ExoContainerContext.getService(CachedJcrWebDavService.class)).thenReturn((Object)mockService);
            Mockito.when((Object)this.event.getType()).thenReturn((Object)4);
            Mockito.when((Object)this.event.getPath()).thenReturn((Object)"/Users/john/file.txt/jcr:data");
            Mockito.when((Object)this.eventIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.eventIterator.nextEvent()).thenReturn((Object)this.event);
            actionNoService.onEvent(this.eventIterator);
            ((CachedJcrWebDavService)Mockito.verify((Object)mockService)).clearCache(FILE_PATH, false);
        }
    }
}

