/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.portlet;

import io.meeds.social.portlet.CMSPortlet;
import io.meeds.social.translation.service.TranslationService;
import java.io.IOException;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;

public class DocumentGadgetPortlet
extends CMSPortlet {
    private static final String HEADER_FIELD_NAME = "headerTitle";
    private static final String OBJECT_TYPE = "documentGadget";
    private TranslationService translationService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.contentType = OBJECT_TYPE;
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String name = request.getPreferences().getValue("name", null);
        String headerTitle = this.getTranslationService().getTranslationLabelOrDefault(OBJECT_TYPE, name, HEADER_FIELD_NAME, request.getLocale());
        if (headerTitle != null) {
            request.setAttribute(HEADER_FIELD_NAME, (Object)headerTitle);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        PortletPreferences preferences = request.getPreferences();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (StringUtils.equals((CharSequence)name, (CharSequence)"action") || StringUtils.contains((CharSequence)name, (CharSequence)"portal:")) continue;
            String value = request.getParameter(name);
            preferences.setValue(name, value);
        }
        preferences.store();
    }

    public TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
        }
        return this.translationService;
    }
}

