/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.exoplatform.documents.webdav.util.PropertyWriteUtil;
import org.springframework.stereotype.Component;

@Component
public class PropFindWebDavHandler
extends WebDavHttpMethodPlugin {
    public PropFindWebDavHandler() {
        super("PROPFIND");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        WebDavItemProperty body = this.parseRequestBodyAsWebDavItemProperty(httpRequest);
        Set requestedPropertyNames = this.getRequestPropertyNames(body);
        String resourcePath = this.getResourcePath(httpRequest);
        int depth = this.getDepthInt(httpRequest);
        String propRequestType = this.getRequestPropertyType(body);
        if (!PropertyConstants.ALLOWED_REQUEST_PROP_TYPES.contains(propRequestType)) {
            httpResponse.setStatus(400);
        }
        boolean requestPropertyNamesOnly = "propname".equals(propRequestType);
        WebDavItem resource = this.documentWebDavService.get(resourcePath, propRequestType, requestedPropertyNames, requestPropertyNamesOnly, depth, this.getBaseUrl(httpRequest), httpRequest.getRemoteUser());
        this.writeResponse(resource, requestedPropertyNames, requestPropertyNamesOnly, depth, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(WebDavItem rootResource, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "text/xml");
        httpResponse.setStatus(207);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)outputStream, DEFAULT_XML_ENCODING);){
            xmlStreamWriter.setNamespaceContext(this.documentWebDavService.getNamespaceContext());
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            this.traverseResources(rootResource, requestedPropertyNames, requestPropertyNamesOnly, 0, depth, xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
    }

    private void traverseResources(WebDavItem resource, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int counter, int depth, XMLStreamWriter xmlStreamWriter) {
        xmlStreamWriter.writeStartElement("DAV:", "response");
        xmlStreamWriter.writeStartElement("DAV:", "href");
        String href = resource.getIdentifier().toASCIIString();
        if (!resource.isFile() && !href.endsWith("/")) {
            xmlStreamWriter.writeCharacters(href + "/");
        } else {
            xmlStreamWriter.writeCharacters(href);
        }
        xmlStreamWriter.writeEndElement();
        PropertyWriteUtil.writePropStats((XMLStreamWriter)xmlStreamWriter, (Map)this.getPropStats(resource, requestedPropertyNames, requestPropertyNamesOnly));
        xmlStreamWriter.writeEndElement();
        if (CollectionUtils.isNotEmpty((Collection)resource.getChildren()) && counter < depth) {
            for (WebDavItem childResource : resource.getChildren()) {
                this.traverseResources(childResource, requestedPropertyNames, requestPropertyNamesOnly, counter + 1, depth, xmlStreamWriter);
            }
        }
    }

    public Map<String, Collection<WebDavItemProperty>> getPropStats(WebDavItem resource, Set<QName> requestedPropertyNames, boolean propertyNamesOnly) {
        HashMap<String, Collection<WebDavItemProperty>> propStats = new HashMap<String, Collection<WebDavItemProperty>>();
        if (requestedPropertyNames == null) {
            String statname = PropertyConstants.getStatusDescription((int)200);
            propStats.put(statname, resource.getProperties(propertyNamesOnly));
        } else {
            for (QName name : requestedPropertyNames) {
                String statname;
                if (name.equals(PropertyConstants.DAV_ALLPROP_INCLUDE)) {
                    String statname2 = PropertyConstants.getStatusDescription((int)200);
                    propStats.put(statname2, resource.getProperties(propertyNamesOnly));
                    continue;
                }
                WebDavItemProperty result = resource.getProperty(name);
                if (result == null) {
                    statname = PropertyConstants.getStatusDescription((int)404);
                    propStats.computeIfAbsent(statname, k -> new ArrayList()).add(new WebDavItemProperty(name));
                    continue;
                }
                statname = PropertyConstants.getStatusDescription((int)200);
                propStats.computeIfAbsent(statname, k -> new ArrayList()).add(result);
            }
        }
        return propStats;
    }
}

