/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.util;

import java.util.Collection;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;

/*
 * Exception performing whole class analysis ignored.
 */
public class PropertyWriteUtil {
    private PropertyWriteUtil() {
    }

    public static void writePropStats(XMLStreamWriter xmlStreamWriter, Map<String, Collection<WebDavItemProperty>> propStatuses) throws XMLStreamException {
        for (Map.Entry<String, Collection<WebDavItemProperty>> stat : propStatuses.entrySet()) {
            xmlStreamWriter.writeStartElement("DAV:", "propstat");
            xmlStreamWriter.writeStartElement("DAV:", "prop");
            for (WebDavItemProperty prop : propStatuses.get(stat.getKey())) {
                PropertyWriteUtil.writeProperty((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)prop);
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("DAV:", "status");
            xmlStreamWriter.writeCharacters(stat.getKey());
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    public static void writeProperty(XMLStreamWriter xmlStreamWriter, WebDavItemProperty prop) throws XMLStreamException {
        if (prop == null) {
            return;
        }
        String uri = prop.getName().getNamespaceURI();
        String prefix = xmlStreamWriter.getNamespaceContext().getPrefix(uri);
        if (prefix == null) {
            prefix = "";
        }
        String local = prop.getName().getLocalPart();
        if (prop.getValue() == null) {
            if (CollectionUtils.isNotEmpty((Collection)prop.getChildren())) {
                xmlStreamWriter.writeStartElement(prefix, local, uri);
                if (!uri.equalsIgnoreCase("DAV:")) {
                    xmlStreamWriter.writeNamespace(prefix, uri);
                }
                PropertyWriteUtil.writeAttributes((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)prop);
                for (int i = 0; i < prop.getChildren().size(); ++i) {
                    WebDavItemProperty property = (WebDavItemProperty)prop.getChildren().get(i);
                    PropertyWriteUtil.writeProperty((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)property);
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeEmptyElement(prefix, local, uri);
                if (!uri.equalsIgnoreCase("DAV:")) {
                    xmlStreamWriter.writeNamespace(prefix, uri);
                }
                PropertyWriteUtil.writeAttributes((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)prop);
            }
        } else {
            xmlStreamWriter.writeStartElement(prefix, local, uri);
            if (!uri.equalsIgnoreCase("DAV:")) {
                xmlStreamWriter.writeNamespace(prefix, uri);
            }
            PropertyWriteUtil.writeAttributes((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)prop);
            xmlStreamWriter.writeCharacters(prop.getValue());
            xmlStreamWriter.writeEndElement();
        }
    }

    public static void writeAttributes(XMLStreamWriter xmlStreamWriter, WebDavItemProperty property) throws XMLStreamException {
        Map attributes = property.getAttributes();
        for (String attrName : attributes.keySet()) {
            String attrValue = (String)attributes.get(attrName);
            xmlStreamWriter.writeAttribute(attrName, attrValue);
        }
    }
}

