/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.documents.webdav.service.DocumentWebDavService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class WebDavHttpMethodPlugin {
    public static final String CONTEXT_PATH = "/webdav/drives";
    public static final String CONTEXT_PATH_ROOT = "/webdav/drives/";
    public static final String CONTEXT_PATH_SINGLE_DRIVE = "/webdav/drives/d";
    public static final String CONTEXT_PATH_SINGLE_DRIVE_ROOT = "/webdav/drives/d/";
    public static final String OPAQUE_LOCK_TOKEN = "opaquelocktoken";
    public static final String INFINITY_DEPTH = "Infinity";
    public static final String IF_MODIFIED_SINCE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String DEFAULT_XML_ENCODING = StandardCharsets.UTF_8.name();
    protected static final Log LOG = ExoLogger.getLogger(WebDavHttpMethodPlugin.class);
    @Autowired
    protected DocumentWebDavService documentWebDavService;
    private String method;

    protected WebDavHttpMethodPlugin(String method) {
        this.method = method;
    }

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2) throws WebDavException;

    protected List<String> getLockTokens(HttpServletRequest httpRequest) {
        String lockTokenHeader = httpRequest.getHeader("lock-token");
        String ifHeader = httpRequest.getHeader("If");
        ArrayList<String> lockTokens = new ArrayList<String>();
        if (lockTokenHeader != null) {
            if (lockTokenHeader.startsWith("<")) {
                lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1);
            }
            if (lockTokenHeader.contains(OPAQUE_LOCK_TOKEN)) {
                lockTokenHeader = lockTokenHeader.split(":")[1];
            }
            lockTokens.add(lockTokenHeader);
        }
        if (ifHeader != null) {
            String headerLockToken = ifHeader.substring(ifHeader.indexOf("("));
            if ((headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2)).contains(OPAQUE_LOCK_TOKEN)) {
                headerLockToken = headerLockToken.split(":")[1];
            }
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }

    protected String getResourcePath(HttpServletRequest httpRequest) {
        String resourcePath = Arrays.stream(httpRequest.getRequestURI().substring(this.getBaseUri(httpRequest).length()).split("/")).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).collect(Collectors.joining("/"));
        return StringUtils.isBlank((CharSequence)resourcePath) ? "/" : resourcePath;
    }

    protected URI getResourceUri(HttpServletRequest httpRequest) {
        return new URI(this.getBaseUrl(httpRequest) + Arrays.stream(this.getResourcePath(httpRequest).split("/")).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20")).collect(Collectors.joining("/")));
    }

    protected String getBaseUrl(HttpServletRequest httpRequest) {
        return CommonsUtils.getCurrentDomain() + this.getBaseUri(httpRequest);
    }

    private String getBaseUri(HttpServletRequest httpRequest) {
        if (httpRequest.getRequestURI().contains(CONTEXT_PATH_SINGLE_DRIVE)) {
            return CONTEXT_PATH_SINGLE_DRIVE;
        }
        return CONTEXT_PATH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WebDavItemProperty parseRequestBodyAsWebDavItemProperty(HttpServletRequest httpRequest) {
        try (ServletInputStream inputStream = httpRequest.getInputStream();){
            if (inputStream.available() <= 0) return null;
            WebDavItemProperty webDavItemProperty = this.parseWebDavItemProperty((InputStream)inputStream);
            return webDavItemProperty;
        }
    }

    protected String getDepth(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("depth");
    }

    protected int getDepthInt(HttpServletRequest httpRequest) {
        String depth = this.getDepth(httpRequest);
        return StringUtils.isBlank((CharSequence)depth) || StringUtils.equalsIgnoreCase((CharSequence)depth, (CharSequence)INFINITY_DEPTH) ? -1 : Integer.parseInt(depth);
    }

    protected String getDestinationPath(HttpServletRequest httpRequest) {
        String resourcePath = Arrays.stream(Arrays.asList(httpRequest.getHeader("Destination").split(this.getBaseUri(httpRequest))).getLast().split("/")).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).collect(Collectors.joining("/"));
        return StringUtils.isBlank((CharSequence)resourcePath) ? "/" : resourcePath;
    }

    protected boolean getOverwriteParameter(HttpServletRequest httpRequest) {
        return StringUtils.equalsIgnoreCase((CharSequence)"f", (CharSequence)httpRequest.getHeader("Overwrite"));
    }

    protected boolean getRemoveDestinationParameter(HttpServletRequest httpRequest) {
        return StringUtils.equalsIgnoreCase((CharSequence)"t", (CharSequence)httpRequest.getHeader("Overwrite"));
    }

    protected boolean checkModified(HttpServletRequest httpRequest, String resourcePath, String version) {
        String ifModifiedSince;
        long lastModifiedDate = this.documentWebDavService.getLastModifiedDate(resourcePath, version);
        String ifNoneMatch = httpRequest.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            if ("*".equals(ifNoneMatch)) {
                return true;
            }
            if (lastModifiedDate > 0L) {
                String resourceEntityTag = String.format("W/%s", lastModifiedDate);
                return Arrays.stream(ifNoneMatch.split(",")).noneMatch(resourceEntityTag::equalsIgnoreCase);
            }
        }
        if ((ifModifiedSince = httpRequest.getHeader("If-Modified-Since")) != null && lastModifiedDate > 0L) {
            Date modifiedDate = new Date(lastModifiedDate);
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_PATTERN, Locale.US);
            Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
            return modifiedDate.getTime() > ifModifiedSinceDate.getTime();
        }
        return true;
    }

    protected void writeResponse(HttpServletResponse httpResponse, int httpCode, String content) {
        httpResponse.setStatus(httpCode);
        PrintWriter writer = httpResponse.getWriter();
        writer.print(content);
        writer.close();
    }

    public final Map<String, Collection<WebDavItemProperty>> getRequestedPropertyStats(WebDavItem resource, Set<QName> requestPropertyNames) {
        HashMap<String, Collection<WebDavItemProperty>> propStats = new HashMap<String, Collection<WebDavItemProperty>>();
        String statName = PropertyConstants.getStatusDescription((int)200);
        if (requestPropertyNames == null) {
            propStats.put(statName, resource.getProperties(false));
        } else {
            if (requestPropertyNames.contains(PropertyConstants.DAV_ALLPROP_INCLUDE)) {
                propStats.put(statName, resource.getProperties(false));
                requestPropertyNames.remove(PropertyConstants.DAV_ALLPROP_INCLUDE);
            }
            for (QName propName : requestPropertyNames) {
                WebDavItemProperty prop = resource.getProperty(propName);
                ((Collection)propStats.getOrDefault(statName, new ArrayList())).add(prop);
            }
        }
        return propStats;
    }

    protected Set<QName> getRequestPropertyNames(WebDavItemProperty body) {
        if (body == null) {
            return null;
        }
        HashSet<QName> names = new HashSet<QName>();
        WebDavItemProperty propBody = body.getChild(PropertyConstants.DAV_ALLPROP_INCLUDE);
        if (propBody != null) {
            names.add(PropertyConstants.DAV_ALLPROP_INCLUDE);
        } else {
            propBody = body.getChild(0);
        }
        List properties = propBody.getChildren();
        for (WebDavItemProperty property : properties) {
            names.add(property.getName());
        }
        return names;
    }

    protected String getRequestPropertyType(WebDavItemProperty body) {
        if (body == null) {
            return "allprop";
        }
        if (body.getChild(PropertyConstants.DAV_ALLPROP_INCLUDE) != null) {
            return "include";
        }
        QName name = body.getChild(0).getName();
        if (name.getNamespaceURI().equals("DAV:")) {
            return name.getLocalPart();
        }
        return null;
    }

    private WebDavItemProperty parseWebDavItemProperty(InputStream entityStream) {
        WebDavItemProperty rootProperty = null;
        LinkedList<WebDavItemProperty> curProperty = new LinkedList<WebDavItemProperty>();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(entityStream);
            XMLEventReader fReader = factory.createFilteredReader(reader, event -> !event.isCharacters() || !((Characters)event).isWhiteSpace());
            while (fReader.hasNext()) {
                XMLEvent event2 = fReader.nextEvent();
                switch (event2.getEventType()) {
                    case 1: {
                        StartElement element = event2.asStartElement();
                        QName name = element.getName();
                        WebDavItemProperty prop = new WebDavItemProperty(name);
                        if (!curProperty.isEmpty()) {
                            ((WebDavItemProperty)curProperty.getLast()).addChild(prop);
                        } else {
                            rootProperty = prop;
                        }
                        curProperty.addLast(prop);
                        break;
                    }
                    case 2: {
                        curProperty.removeLast();
                        break;
                    }
                    case 4: {
                        String chars = event2.asCharacters().getData();
                        ((WebDavItemProperty)curProperty.getLast()).setValue(chars);
                        break;
                    }
                }
            }
            return rootProperty;
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"An XMLStreamException occurs", (Throwable)e);
            }
            return null;
        }
        catch (RuntimeException e) {
            if ("com.ctc.wstx.exc.WstxLazyException".equals(e.getClass().getName())) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
            throw e;
        }
    }

    @Generated
    public DocumentWebDavService getDocumentWebDavService() {
        return this.documentWebDavService;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }
}

