/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.documents.webdav.model.constant.FileConstants;
import org.exoplatform.documents.webdav.service.WebDavHttpMethodDispatcher;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="drives")
@Tag(name="/webdav/drives", description="Managing WebDav Files")
@CrossOrigin(value={"*"})
public class WebDavRest {
    protected static final Log LOG = ExoLogger.getLogger(WebDavRest.class);
    @Autowired
    private PortalContainer container;
    @Autowired
    private WebDavHttpMethodDispatcher webDavMethodDispatcher;

    @Secured(value={"users"})
    @RequestMapping(path={"/**"}, produces={"*/*"}, headers={"Connection!=Upgrade"})
    @Operation(summary="Handles All WebDav requests")
    public void webdav(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.handle(httpRequest, httpResponse);
    }

    @RequestMapping(path={"/**"}, produces={"*/*"}, method={RequestMethod.OPTIONS}, headers={"Connection!=Upgrade"})
    @Operation(summary="Handles OPTIONS Http Method WebDav requests")
    public void options(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.handle(httpRequest, httpResponse);
    }

    protected void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        block9: {
            if (FileConstants.BLOCKED_FILES_PATTERN.matcher(httpRequest.getRequestURI()).find()) {
                httpResponse.sendError(403);
                break block9;
            }
            if (httpRequest.getRequestURI().contains("/webdav/drives") && !httpRequest.getRequestURI().endsWith("/webdav/drives/d") && !httpRequest.getRequestURI().endsWith("/webdav/drives/d/")) {
                ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                RequestLifeCycle.begin((ExoContainer)this.container);
                try {
                    httpResponse.setHeader("Vary", "Origin");
                    this.webDavMethodDispatcher.handle(httpRequest, httpResponse);
                    break block9;
                }
                finally {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer(null);
                }
            }
            try {
                LOG.warn("Redirect to main path {}", new Object[]{"/webdav/drives/"});
                httpResponse.sendRedirect("/webdav/drives/");
            }
            catch (IOException e) {
                LOG.error("Error while redirecting to context path {}", new Object[]{"/webdav/drives/", e});
            }
        }
    }
}

