/*
 * Decompiled with CFR 0.152.
 */
package hero.hook;

import hero.hook.NodeHookI;
import hero.interfaces.BnNodeLocal;
import hero.interfaces.ProjectSessionLocal;
import hero.interfaces.ProjectSessionLocalHome;
import hero.interfaces.ProjectSessionUtil;
import hero.util.HeroHookException;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class ContentBackupWaitSwitchHook
implements NodeHookI {
    public static final String CONTAINER_PROPERTY_NAME = "containername";
    public static final String NODE_PATH_PROPERTY_NAME = "nodePath";
    public static final String SRC_WORKSPACE_PROPERTY_NAME = "srcWorkspace";
    public static final String REPOSITORY_PROPERTY_NAME = "repository";
    public static final String WAIT_ACTIVITY_NAME = "wait";
    public static final String WAIT_PROPERTY_NAME = "wait";

    public String getMetadata() {
        return "beforeTerminate";
    }

    public void beforeStart(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void afterStart(Object obj, BnNodeLocal node) throws HeroHookException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTerminate(Object obj, BnNodeLocal node) throws HeroHookException {
        ProjectSessionLocal projectSession = null;
        try {
            String projectName = node.getBnProject().getName();
            ProjectSessionLocalHome projectSessionHome = ProjectSessionUtil.getLocalHome();
            projectSession = projectSessionHome.create();
            projectSession.initProject(projectName);
            String nodeName = node.getName();
            String nodePath = projectSession.getProperty(NODE_PATH_PROPERTY_NAME).getTheValue();
            String srcWorkspace = projectSession.getProperty(SRC_WORKSPACE_PROPERTY_NAME).getTheValue();
            String repository = projectSession.getProperty(REPOSITORY_PROPERTY_NAME).getTheValue();
            PortalContainer container = PortalContainer.getInstance();
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            Session session = repositoryService.getRepository(repository).getSystemSession(srcWorkspace);
            Node srcNode = (Node)session.getItem(nodePath);
            if (!srcNode.isNodeType("exo:published")) {
                projectSession.setNodeProperty(nodeName, "wait", "end", false);
            } else {
                long relativeDeadline = srcNode.getProperty("exo:endPublication").getDate().getTimeInMillis() - new Date().getTime();
                if (relativeDeadline > 0L) {
                    projectSession.setNodeProperty(nodeName, "wait", "wait", false);
                    ArrayList<Long> deadlines = new ArrayList<Long>();
                    deadlines.add(relativeDeadline);
                    projectSession.setNodeRelativeDeadlines("wait", deadlines);
                    projectSession.setProperty(CONTAINER_PROPERTY_NAME, PortalContainer.getInstance().getPortalContainerInfo().getContainerName());
                } else {
                    projectSession.setNodeProperty(nodeName, "wait", "backup", false);
                }
            }
            session.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                projectSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    public void afterTerminate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void anticipate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onCancel(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onDeadline(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onReady(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }
}

