/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.exoplatform.processes.publishing.ManagePublicationActionHandler;
import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.log.ExoLogger;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.scheduler.exe.Timer;

public class SchedulePublicationTimerActionHandler
extends ManagePublicationActionHandler {
    private static final long serialVersionUID = 1L;
    private Log log = ExoLogger.getLogger(this.getClass());

    public void execute(ExecutionContext context) {
        ProcessUtil.approve((ExecutionContext)context);
        Date startDate = (Date)context.getVariable("startDate");
        Date currentDate = new Date();
        if (startDate.before(currentDate)) {
            try {
                this.publishContent(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error((Object)e);
            }
            context.getToken().signal("publication-done");
        } else {
            try {
                this.moveToPending(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error((Object)e);
            }
            Delegation delegation = new Delegation();
            delegation.setClassName("org.exoplatform.processes.publishing.ManagePublicationActionHandler");
            delegation.setProcessDefinition(context.getProcessDefinition());
            Action publicationAction = new Action();
            publicationAction.setName("publicationAction");
            publicationAction.setActionDelegation(delegation);
            context.getProcessDefinition().addAction(publicationAction);
            Timer timer = new Timer(context.getToken());
            timer.setName("publicationTimer");
            timer.setDueDate(startDate);
            timer.setGraphElement(context.getEventSource());
            timer.setTaskInstance(context.getTaskInstance());
            timer.setAction(publicationAction);
            timer.setTransitionName("manage-backup");
            context.getSchedulerInstance().schedule(timer);
        }
    }

    private void moveToPending(ExecutionContext context) throws Exception {
        String[] currentLocation = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = currentLocation[0];
        String currentWorkspace = currentLocation[1];
        String currentPath = currentLocation[2];
        String pendingWorksapce = (String)context.getVariable("exo:pendingWorkspace");
        String pendingPath = (String)context.getVariable("exo:pendingPath");
        String destPath = ProcessUtil.computeDestinationPath((String)currentPath, (String)pendingPath);
        CmsService cmsService = (CmsService)ProcessUtil.getService(CmsService.class);
        cmsService.moveNode(currentPath, currentWorkspace, pendingWorksapce, destPath, repository);
        ProcessUtil.setCurrentLocation((ExecutionContext)context, (String)pendingWorksapce, (String)destPath);
        ProcessUtil.waitForPublish((ExecutionContext)context);
    }
}

