/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.services.cms.folksonomy.impl.TagStylePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolksonomyServiceImpl
implements FolksonomyService,
Startable {
    private static final String EXO_FOLKSONOMIZED_MIXIN = "exo:folksonomized".intern();
    private static final String EXO_FOLKSONOMY_PROP = "exo:folksonomy".intern();
    private static final String MIX_REFERENCEABLE_MIXIN = "mix:referenceable".intern();
    private static final String EXO_TAG = "exo:tag".intern();
    private static final String TAG_CREATED_DATE_PROP = "exo:tagCreatedDate".intern();
    private static final String TAG_STATUS_PROP = "exo:tagStatus".intern();
    private static final String TAG_LAST_UPDATED_DATE_PROP = "exo:lastUpdatedDate".intern();
    private static final String TAG_RATE_PROP = "exo:styleRange".intern();
    private static final String HTML_STYLE_PROP = "exo:htmlStyle".intern();
    private static final String NORMAL_STYLE = "nomal".intern();
    private static final String INTERSTING_STYLE = "interesting".intern();
    private static final String ATTRACTIVE_STYLE = "attractive".intern();
    private static final String HOT_STYLE = "hot".intern();
    private static final String HOSTES_STYLE = "hotest".intern();
    private RepositoryService repoService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String baseTagsPath_;
    private String exoTagStylePath_;
    private List<TagStylePlugin> plugin_ = new ArrayList<TagStylePlugin>();
    private ExoCache cache_;

    public FolksonomyServiceImpl(RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, CacheService cacheService) throws Exception {
        this.repoService_ = repoService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseTagsPath_ = this.nodeHierarchyCreator_.getJcrPath("exoTagsPath");
        this.exoTagStylePath_ = this.nodeHierarchyCreator_.getJcrPath("exoTagStylePath");
        this.cache_ = cacheService.getCacheInstance(FolksonomyServiceImpl.class.getName());
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            System.out.println("===>>>>Exception when init FolksonomySerice" + e.getMessage());
        }
    }

    public void stop() {
    }

    public void addTagStylePlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagStylePlugin) {
            this.plugin_.add((TagStylePlugin)plugin);
        }
    }

    private void init() throws Exception {
        for (TagStylePlugin plugin : this.plugin_) {
            try {
                plugin.init();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TagStylePlugin plugin : this.plugin_) {
            try {
                plugin.init(repository);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void addTag(Node node, String[] tagNames, String repository) throws Exception {
        Session systemSession = this.getSystemSession(repository);
        Session currentSession = node.getSession();
        Node exoTagsHomeNode_ = (Node)systemSession.getItem(this.baseTagsPath_);
        Node taggingNode = null;
        for (String tagName : tagNames) {
            if (!exoTagsHomeNode_.hasNode(tagName)) {
                taggingNode = exoTagsHomeNode_.addNode(tagName, EXO_TAG);
                taggingNode.addMixin(MIX_REFERENCEABLE_MIXIN);
                taggingNode.setProperty(TAG_CREATED_DATE_PROP, (Calendar)new GregorianCalendar());
                taggingNode.setProperty(TAG_STATUS_PROP, "nomal");
            } else {
                taggingNode = exoTagsHomeNode_.getNode(tagName);
            }
            Value value2add = currentSession.getValueFactory().createValue(taggingNode);
            if (!node.isNodeType(EXO_FOLKSONOMIZED_MIXIN)) {
                node.addMixin(EXO_FOLKSONOMIZED_MIXIN);
                node.setProperty(EXO_FOLKSONOMY_PROP, new Value[]{value2add});
            } else {
                Value[] folksonomyValues = node.getProperty(EXO_FOLKSONOMY_PROP).getValues();
                String currenUUID = taggingNode.getUUID();
                ArrayList<Value> vals = new ArrayList<Value>();
                for (Value value : folksonomyValues) {
                    String uuid = value.getString();
                    if (uuid.equals(currenUUID)) {
                        return;
                    }
                    vals.add(value);
                }
                vals.add(value2add);
                node.setProperty(EXO_FOLKSONOMY_PROP, vals.toArray(new Value[vals.size()]));
            }
            exoTagsHomeNode_.save();
            node.save();
            this.updateTagStatus(taggingNode.getPath(), repository);
        }
        currentSession.save();
        systemSession.save();
        systemSession.logout();
    }

    @Override
    public Node getTag(String path, String repository) throws Exception {
        Session systemSession = this.getSystemSession(repository);
        return (Node)systemSession.getItem(path);
    }

    @Override
    public List<Node> getDocumentsOnTag(String tagPath, String repository) throws Exception {
        ArrayList<Node> documentList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession(repository);
        Node tagNode = (Node)systemSession.getItem(tagPath);
        String uuid = tagNode.getUUID();
        String[] workspaces = this.repoService_.getRepository(repository).getWorkspaceNames();
        Session sessionOnWS = null;
        for (String workspaceName : workspaces) {
            sessionOnWS = this.repoService_.getRepository(repository).getSystemSession(workspaceName);
            Node tagNodeOnWS = sessionOnWS.getNodeByUUID(uuid);
            PropertyIterator iter = tagNodeOnWS.getReferences();
            while (iter.hasNext()) {
                Property folksonomy = iter.nextProperty();
                Node document = folksonomy.getParent();
                documentList.add(document);
            }
            sessionOnWS.logout();
        }
        systemSession.logout();
        return documentList;
    }

    @Override
    public List<Node> getAllTags(String repository) throws Exception {
        ArrayList<Node> tagList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession(repository);
        Node exoTagsHomeNode_ = (Node)systemSession.getItem(this.baseTagsPath_);
        NodeIterator iter = exoTagsHomeNode_.getNodes();
        while (iter.hasNext()) {
            tagList.add(iter.nextNode());
        }
        systemSession.logout();
        return tagList;
    }

    @Override
    public List<Node> getAllTagStyle(String repository) throws Exception {
        ArrayList<Node> tagStyleList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession(repository);
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        NodeIterator iter = tagStyleHomeNode.getNodes();
        while (iter.hasNext()) {
            tagStyleList.add(iter.nextNode());
        }
        systemSession.logout();
        return tagStyleList;
    }

    protected Session getSystemSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repoService_.getRepository(repository);
        return manageableRepository.getSystemSession(manageableRepository.getConfiguration().getSystemWorkspaceName());
    }

    @Override
    public String getTagStyle(String styleName, String repository) throws Exception {
        Session systemSession = this.getSystemSession(repository);
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        Node tagStyle = tagStyleHomeNode.getNode(styleName);
        String htmlStyle = tagStyle.getProperty(HTML_STYLE_PROP).getValue().getString();
        systemSession.logout();
        return htmlStyle;
    }

    @Override
    public void updateStype(String tagPath, String tagRate, String htmlStyle, String repository) throws Exception {
        Session session = this.getSystemSession(repository);
        Node tagStyle = (Node)session.getItem(tagPath);
        tagStyle.setProperty(TAG_RATE_PROP, tagRate);
        tagStyle.setProperty(HTML_STYLE_PROP, htmlStyle);
        tagStyle.save();
        session.save();
        session.logout();
    }

    private void updateTagStatus(String tagPath, String repository) throws Exception {
        int numberOfDocumentOnTag = this.getDocumentsOnTag(tagPath, repository).size();
        Session systemSession = this.getSystemSession(repository);
        Node selectedTagNode = (Node)systemSession.getItem(tagPath);
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        Node tagStyle = null;
        NodeIterator iter = tagStyleHomeNode.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!this.checkTagRateOnTagStyle(numberOfDocumentOnTag, node)) continue;
            tagStyle = node;
            break;
        }
        if (tagStyle != null) {
            String styleName = tagStyle.getName();
            if (NORMAL_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "nomal");
            } else if (INTERSTING_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "interesting");
            } else if (ATTRACTIVE_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "attractive");
            } else if (HOT_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "hot");
            } else if (HOSTES_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "hotest");
            }
            selectedTagNode.setProperty(TAG_LAST_UPDATED_DATE_PROP, (Calendar)new GregorianCalendar());
            selectedTagNode.save();
            systemSession.save();
            systemSession.refresh(true);
        }
        systemSession.logout();
    }

    private boolean checkTagRateOnTagStyle(int numOfDocument, Node tagStyle) throws Exception {
        String tagRate = tagStyle.getProperty(TAG_RATE_PROP).getValue().getString();
        String[] vals = StringUtils.split((String)tagRate, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return minValue <= numOfDocument && numOfDocument < maxValue;
    }

    @Override
    public List<Node> getLinkedTagsOfDocument(Node document, String repository) throws Exception {
        if (document == null || !document.hasProperty(EXO_FOLKSONOMY_PROP)) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> tagList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession(repository);
        try {
            Value[] values;
            for (Value v : values = document.getProperty(EXO_FOLKSONOMY_PROP).getValues()) {
                String uuid = v.getString();
                tagList.add(systemSession.getNodeByUUID(uuid));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        systemSession.logout();
        return tagList;
    }
}

