/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.presentation;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/publication/presentation/")
public class PublicationGetDocumentRESTService
implements ResourceContainer {
    private RepositoryService repositoryService_;
    private PublicationService publicationService_;

    public PublicationGetDocumentRESTService(RepositoryService repositoryService, PublicationService publicationService) {
        this.repositoryService_ = repositoryService;
        this.publicationService_ = publicationService;
    }

    @URITemplate(value="/{repository}/{workspace}/{state}/")
    @HTTPMethod(value="GET")
    public Response getPublishDocument(@URIParam(value="repository") String repoName, @URIParam(value="workspace") String wsName, @URIParam(value="state") String state, @QueryParam(value="showItems") String showItems) throws Exception {
        return this.getPublishDocument(repoName, wsName, state, null, showItems);
    }

    @URITemplate(value="/{repository}/{workspace}/{publicationPluginName}/{state}/")
    @HTTPMethod(value="GET")
    public Response getPublishDocument1(@URIParam(value="repository") String repoName, @URIParam(value="workspace") String wsName, @URIParam(value="publicationPluginName") String pluginName, @URIParam(value="state") String state, @QueryParam(value="showItems") String showItems) throws Exception {
        return this.getPublishDocument(repoName, wsName, state, pluginName, showItems);
    }

    private Response getPublishDocument(String repoName, String wsName, String state, String pluginName, String itemPage) throws Exception {
        int item = Integer.parseInt(itemPage);
        String queryStatement = "select * from publication:publication";
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        Session session = provider.getSession(wsName, this.repositoryService_.getRepository(repoName));
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStatement, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        List<Node> listNode = this.getNodePublish(iter, pluginName);
        Collections.sort(listNode, new DateComparator());
        List<Object> listDocumentPublish = new ArrayList();
        if (item < listNode.size()) {
            for (int i = 0; i < item; ++i) {
                listDocumentPublish.add(listNode.get(i));
            }
        } else {
            listDocumentPublish = listNode;
        }
        for (Node node : listDocumentPublish) {
            System.out.println("\n" + node.getPath() + "\n");
        }
        return Response.Builder.ok().build();
    }

    private List<Node> getNodePublish(NodeIterator iter, String pluginName) throws Exception {
        ArrayList<Node> listNode = new ArrayList<Node>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            Node nodecheck = this.publicationService_.getNodePublish(node, pluginName);
            if (nodecheck == null) continue;
            listNode.add(nodecheck);
        }
        return listNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateComparator
    implements Comparator<Node> {
        private DateComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
                Date date1 = formatter.parse(this.getDateTime(node1));
                Date date2 = formatter.parse(this.getDateTime(node2));
                return date2.compareTo(date1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        private String getDateTime(Node currentNode) throws Exception {
            int i$ = 0;
            Value[] history = currentNode.getProperty("publication:history").getValues();
            Value[] arr$ = history;
            int len$ = arr$.length;
            if (i$ < len$) {
                Value value = arr$[i$];
                String[] arrHistory = value.getString().split(",");
                return arrHistory[0];
            }
            return "";
        }
    }
}

