/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.security.SecurityService;

public abstract class BaseActionLauncherListener
implements ECMEventListener {
    protected String actionName_;
    protected String repository_;
    protected String srcWorkspace_;
    protected String srcPath_;
    protected String executable_;
    protected Map actionVariables_;

    public BaseActionLauncherListener(String actionName, String executable, String repository, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
        this.actionName_ = actionName;
        this.executable_ = executable;
        this.repository_ = repository;
        this.srcWorkspace_ = srcWorkspace;
        this.srcPath_ = srcPath;
        this.actionVariables_ = actionVariables;
    }

    public String getSrcWorkspace() {
        return this.srcWorkspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void onEvent(EventIterator events) {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        SecurityService securityService = (SecurityService)exoContainer.getComponentInstanceOfType(SecurityService.class);
        TemplateService templateService = (TemplateService)exoContainer.getComponentInstanceOfType(TemplateService.class);
        if (events.hasNext()) {
            Event event = events.nextEvent();
            Node node = null;
            Session jcrSession = null;
            try {
                jcrSession = repositoryService.getRepository(this.repository_).getSystemSession(this.srcWorkspace_);
                node = (Node)jcrSession.getItem(this.srcPath_);
                String userId = event.getUserID();
                Node actionNode = actionServiceContainer.getAction(node, this.actionName_);
                Property rolesProp = actionNode.getProperty("exo:roles");
                boolean hasPermission = false;
                Value[] roles = rolesProp.getValues();
                for (int i = 0; i < roles.length; ++i) {
                    String role = roles[i].getString();
                    if (!securityService.hasMembershipInGroup(userId, role) && !SystemIdentity.SYSTEM.equals(userId)) continue;
                    hasPermission = true;
                    break;
                }
                if (!hasPermission) {
                    jcrSession.logout();
                    return;
                }
                String path = event.getPath();
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("initiator", userId);
                variables.put("actionName", this.actionName_);
                variables.put("nodePath", path);
                variables.put("repository", this.repository_);
                variables.put("srcWorkspace", this.srcWorkspace_);
                variables.put("srcPath", this.srcPath_);
                variables.putAll(this.actionVariables_);
                if (event.getType() == 1) {
                    node = (Node)jcrSession.getItem(path);
                    String nodeType = node.getPrimaryNodeType().getName();
                    if (templateService.getDocumentTemplates(this.repository_).contains(nodeType)) {
                        variables.put("document-type", nodeType);
                        this.triggerAction(userId, variables, this.repository_);
                    }
                } else {
                    this.triggerAction(userId, variables, this.repository_);
                }
                jcrSession.logout();
            }
            catch (Exception e) {
                jcrSession.logout();
                e.printStackTrace();
            }
        }
    }

    public abstract void triggerAction(String var1, Map var2, String var3) throws Exception;
}

