/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.queries.impl.QueryPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryServiceImpl
implements QueryService,
Startable {
    private static final String[] perms = new String[]{"read", "add_node", "set_property", "remove"};
    private String relativePath_;
    private List<QueryPlugin> queryPlugins_ = new ArrayList<QueryPlugin>();
    private RepositoryService repositoryService_;
    private CacheService cacheService_;
    private PortalContainerInfo containerInfo_;
    private OrganizationService organizationService_;
    private String baseUserPath_;
    private String baseQueriesPath_;
    private String group_;

    public QueryServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params, PortalContainerInfo containerInfo, CacheService cacheService, OrganizationService organizationService) throws Exception {
        this.relativePath_ = params.getValueParam("relativePath").getValue();
        this.group_ = params.getValueParam("group").getValue();
        this.repositoryService_ = repositoryService;
        this.containerInfo_ = containerInfo;
        this.cacheService_ = cacheService;
        this.organizationService_ = organizationService;
        this.baseUserPath_ = nodeHierarchyCreator.getJcrPath("usersPath");
        this.baseQueriesPath_ = nodeHierarchyCreator.getJcrPath("queriesPath");
    }

    public void start() {
        for (QueryPlugin queryPlugin : this.queryPlugins_) {
            try {
                queryPlugin.init(this.baseQueriesPath_);
            }
            catch (Exception e) {
                System.out.println("[WARNING] ==> Can not init query plugin '" + queryPlugin.getName() + "'");
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        for (QueryPlugin queryPlugin : this.queryPlugins_) {
            try {
                queryPlugin.init(repository, this.baseQueriesPath_);
            }
            catch (Exception e) {
                System.out.println("[WARNING] ==> Can not init query plugin '" + queryPlugin.getName() + "'");
            }
        }
    }

    public void setQueryPlugin(QueryPlugin queryPlugin) {
        this.queryPlugins_.add(queryPlugin);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath_;
    }

    @Override
    public List<Query> getQueries(String userName, String repository, SessionProvider provider) throws Exception {
        ArrayList<Query> queries = new ArrayList<Query>();
        if (userName == null) {
            return queries;
        }
        Session session = this.getSession(repository, provider);
        QueryManager manager = session.getWorkspace().getQueryManager();
        Node usersHome = (Node)session.getItem(this.baseUserPath_);
        Node userHome = null;
        if (usersHome.hasNode(userName)) {
            userHome = usersHome.getNode(userName);
        } else {
            userHome = usersHome.addNode(userName);
            if (userHome.canAddMixin("exo:privilegeable")) {
                userHome.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)userHome).setPermissions(this.getPermissions(userName));
            Node query = null;
            query = userHome.hasNode(this.relativePath_) ? userHome.getNode(this.relativePath_) : this.getNodeByRelativePath(userHome, this.relativePath_);
            if (query.canAddMixin("exo:privilegeable")) {
                query.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)query).setPermissions(this.getPermissions(userName));
            usersHome.save();
        }
        Node queriesHome = null;
        queriesHome = userHome.hasNode(this.relativePath_) ? userHome.getNode(this.relativePath_) : this.getNodeByRelativePath(userHome, this.relativePath_);
        NodeIterator iter = queriesHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!"nt:query".equals(node.getPrimaryNodeType().getName())) continue;
            queries.add(manager.getQuery(node));
        }
        return queries;
    }

    private Node getNodeByRelativePath(Node userHome, String relativePath) throws Exception {
        String[] paths = relativePath.split("/");
        String relPath = null;
        Node queriesHome = null;
        for (String path : paths) {
            if (userHome.hasNode(relPath = relPath == null ? path : relPath + "/" + path)) continue;
            queriesHome = userHome.addNode(relPath);
        }
        return queriesHome;
    }

    private Map<String, String[]> getPermissions(String owner) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put(owner, perms);
        permissions.put(this.group_, perms);
        return permissions;
    }

    @Override
    public void addQuery(String queryName, String statement, String language, String userName, String repository) throws Exception {
        Node userNode;
        if (userName == null) {
            return;
        }
        Session session = this.getSession(repository);
        QueryManager manager = session.getWorkspace().getQueryManager();
        Query query = manager.createQuery(statement, language);
        Node usersNode = (Node)session.getItem(this.baseUserPath_);
        if (!usersNode.hasNode(userName)) {
            usersNode.addNode(userName);
            usersNode.save();
        }
        if (!(userNode = usersNode.getNode(userName)).hasNode(this.relativePath_)) {
            this.getNodeByRelativePath(userNode, this.relativePath_);
            userNode.save();
            session.save();
        }
        String absPath = this.baseUserPath_ + "/" + userName + "/" + this.relativePath_ + "/" + queryName;
        query.storeAsNode(absPath);
        session.refresh(true);
        session.getItem(this.baseUserPath_).save();
        session.save();
        session.logout();
    }

    @Override
    public void removeQuery(String queryPath, String userName, String repository) throws Exception {
        if (userName == null) {
            return;
        }
        Session session = this.getSession(repository);
        Node queryNode = (Node)session.getItem(queryPath);
        Node queriesHome = queryNode.getParent();
        queryNode.remove();
        queriesHome.save();
        session.save();
        session.logout();
        this.removeFromCache(queryPath);
    }

    @Override
    public void addSharedQuery(String queryName, String statement, String language, String[] permissions, boolean cachedResult, String repository) throws Exception {
        String queryPath;
        Session session = this.getSession(repository);
        ValueFactory vt = session.getValueFactory();
        ArrayList<Value> perm = new ArrayList<Value>();
        for (String permission : permissions) {
            Value vl = vt.createValue(permission);
            perm.add(vl);
        }
        Value[] vls = perm.toArray(new Value[0]);
        String queriesPath = this.baseQueriesPath_;
        Node queryHome = (Node)session.getItem(this.baseQueriesPath_);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        queryManager.createQuery(statement, language);
        if (queryHome.hasNode(queryName)) {
            Node query = queryHome.getNode(queryName);
            query.setProperty("jcr:language", language);
            query.setProperty("jcr:statement", statement);
            query.setProperty("exo:permissions", vls);
            query.setProperty("exo:cachedResult", cachedResult);
            query.save();
            session.save();
            queryPath = query.getPath();
        } else {
            QueryManager manager = session.getWorkspace().getQueryManager();
            Query query = manager.createQuery(statement, language);
            Node newQuery = query.storeAsNode(this.baseQueriesPath_ + "/" + queryName);
            newQuery.addMixin("mix:sharedQuery");
            newQuery.setProperty("exo:permissions", vls);
            newQuery.setProperty("exo:cachedResult", cachedResult);
            session.getItem(queriesPath).save();
            queryPath = queriesPath;
        }
        session.logout();
        this.removeFromCache(queryPath);
    }

    @Override
    public Node getSharedQuery(String queryName, String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return (Node)session.getItem(this.baseQueriesPath_ + "/" + queryName);
    }

    @Override
    public List<Node> getSharedQueries(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        ArrayList<Node> queries = new ArrayList<Node>();
        Node sharedQueryHome = (Node)session.getItem(this.baseQueriesPath_);
        NodeIterator iter = sharedQueryHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!"nt:query".equals(node.getPrimaryNodeType().getName())) continue;
            queries.add(node);
        }
        return queries;
    }

    @Override
    public List<Node> getSharedQueries(String userId, String repository, SessionProvider provider) throws Exception {
        ArrayList<Node> sharedQueries = new ArrayList<Node>();
        for (Node query : this.getSharedQueries(repository, provider)) {
            if (!this.canUseQuery(userId, query)) continue;
            sharedQueries.add(query);
        }
        return sharedQueries;
    }

    @Override
    public List<Node> getSharedQueries(String queryType, String userId, String repository, SessionProvider provider) throws Exception {
        ArrayList<Node> resultList = new ArrayList<Node>();
        String language = null;
        for (Node queryNode : this.getSharedQueries(repository, provider)) {
            language = queryNode.getProperty("jcr:language").getString();
            if (!queryType.equalsIgnoreCase(language) || !this.canUseQuery(userId, queryNode)) continue;
            resultList.add(queryNode);
        }
        return resultList;
    }

    @Override
    public Query getQueryByPath(String queryPath, String userName, String repository, SessionProvider provider) throws Exception {
        List<Query> queries = this.getQueries(userName, repository, provider);
        for (Query query : queries) {
            if (!query.getStoredQueryPath().equals(queryPath)) continue;
            return query;
        }
        return null;
    }

    @Override
    public void removeSharedQuery(String queryName, String repository) throws Exception {
        Session session = this.getSession(repository);
        session.getItem(this.baseQueriesPath_ + "/" + queryName).remove();
        session.save();
        session.logout();
    }

    @Override
    public QueryResult execute(String queryPath, String workspace, String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        Node queryNode = (Node)session.getItem(queryPath);
        if (queryNode.hasProperty("exo:cachedResult") && queryNode.getProperty("exo:cachedResult").getBoolean()) {
            String portalName;
            String key;
            ExoCache queryCache = this.cacheService_.getCacheInstance(QueryServiceImpl.class.getName());
            QueryResult result = (QueryResult)queryCache.get((Serializable)((Object)(key = (portalName = this.containerInfo_.getContainerName()) + queryPath)));
            if (result != null) {
                return result;
            }
            Session querySession = this.getSession(repository, workspace, provider);
            result = this.execute(querySession, queryNode);
            queryCache.put((Serializable)((Object)key), (Object)result);
            return result;
        }
        Session querySession = this.getSession(repository, workspace, provider);
        return this.execute(querySession, queryNode);
    }

    private QueryResult execute(Session session, Node queryNode) throws Exception {
        String statement = this.computeStatement(session, queryNode.getProperty("jcr:statement").getString());
        String language = queryNode.getProperty("jcr:language").getString();
        Query query = session.getWorkspace().getQueryManager().createQuery(statement, language);
        return query.execute();
    }

    private String computeStatement(Session session, String statement) {
        String ret = statement;
        String userId = session.getUserID();
        ret = ret.replace("${UserId}$", userId);
        String currentDate = ISO8601.format((Calendar)new GregorianCalendar());
        ret = ret.replace("${Date}$", currentDate);
        return ret;
    }

    private void removeFromCache(String queryPath) throws Exception {
        String portalName;
        String key;
        ExoCache queryCache = this.cacheService_.getCacheInstance(QueryServiceImpl.class.getName());
        QueryResult result = (QueryResult)queryCache.get((Serializable)((Object)(key = (portalName = this.containerInfo_.getContainerName()) + queryPath)));
        if (result != null) {
            queryCache.remove((Serializable)((Object)key));
        }
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String workspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return manageableRepository.getSystemSession(workspace);
    }

    private Session getSession(String repository, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String workspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return provider.getSession(workspace, manageableRepository);
    }

    private Session getSession(String repository, String workspace, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        return provider.getSession(workspace, manageableRepository);
    }

    private boolean canUseQuery(String userId, Node queryNode) throws Exception {
        Value[] values;
        for (Value value : values = queryNode.getProperty("exo:permissions").getValues()) {
            String accessPermission = value.getString();
            if (!this.hasMembership(userId, accessPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMembership(String userId, String roleExpression) {
        if ("*".equals(roleExpression)) {
            return true;
        }
        String membershipType = roleExpression.substring(0, roleExpression.indexOf(":"));
        String groupName = roleExpression.substring(roleExpression.indexOf(":") + 1);
        try {
            MembershipHandler membershipHandler = this.organizationService_.getMembershipHandler();
            if ("*".equals(membershipType)) {
                return !membershipHandler.findMembershipsByUserAndGroup(userId, groupName).isEmpty();
            }
            return membershipHandler.findMembershipByUserGroupAndType(userId, groupName, membershipType) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

