/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.records.impl;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.records.RecordsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.scheduler.BaseJob;
import org.exoplatform.services.scheduler.JobContext;

public class RecordsJob
extends BaseJob {
    private static final String QUERY = "SELECT * FROM rma:filePlan";
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");
    private RepositoryService repositoryService_;
    private RecordsService recordsService_;

    public void execute(JobContext context) throws Exception {
        block10: {
            Session session = null;
            try {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"File plan job started");
                }
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                this.repositoryService_ = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                this.recordsService_ = (RecordsService)container.getComponentInstanceOfType(RecordsService.class);
                ManageableRepository repository = this.repositoryService_.getDefaultRepository();
                String[] workspaces = repository.getWorkspaceNames();
                for (int i = 0; i < workspaces.length; ++i) {
                    String workspaceName = workspaces[i];
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("Search File plans in workspace : " + workspaceName));
                    }
                    session = repository.getSystemSession(workspaceName);
                    QueryManager queryManager = session.getWorkspace().getQueryManager();
                    Query query = queryManager.createQuery(QUERY, "sql");
                    QueryResult results = query.execute();
                    NodeIterator iter = results.getNodes();
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("File plan nodes : " + iter.getSize()));
                    }
                    while (iter.hasNext()) {
                        Node filePlan = iter.nextNode();
                        try {
                            this.recordsService_.computeCutoffs(filePlan);
                            this.recordsService_.computeHolds(filePlan);
                            this.recordsService_.computeTransfers(filePlan);
                            this.recordsService_.computeAccessions(filePlan);
                            this.recordsService_.computeDestructions(filePlan);
                        }
                        catch (RepositoryException ex) {
                            log_.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    session.logout();
                }
            }
            catch (Exception e) {
                if (session == null) break block10;
                session.logout();
            }
        }
        if (log_.isDebugEnabled()) {
            log_.debug((Object)"File plan job done");
        }
    }
}

