/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfig {
    private String name;
    private String permissions;
    private String template;
    private List<Tab> tabList = new ArrayList<Tab>(5);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permission) {
        this.permissions = permission;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String templ) {
        this.template = templ;
    }

    public List<Tab> getTabList() {
        return this.tabList;
    }

    public void setTabList(List<Tab> tabs) {
        this.tabList = tabs;
    }

    public List getAllPermissions() {
        String[] allPermissions = StringUtils.split((String)this.permissions, (String)";");
        ArrayList<String> permissionList = new ArrayList<String>();
        for (int i = 0; i < allPermissions.length; ++i) {
            permissionList.add(allPermissions[i].trim());
        }
        return permissionList;
    }

    public boolean hasPermission(String permission) {
        List permissions = this.getAllPermissions();
        if (permission == null) {
            return false;
        }
        String[] array = StringUtils.split((String)permission, (String)":/");
        if (array == null || array.length < 2) {
            return false;
        }
        int i = permissions.indexOf("*:/" + array[1]);
        if (i > -1) {
            return true;
        }
        return permissions.contains(permission);
    }

    public static class Tab {
        private String tabName;
        private String buttons;

        public String getTabName() {
            return this.tabName;
        }

        public void setTabName(String name) {
            this.tabName = name;
        }

        public String getButtons() {
            return this.buttons;
        }

        public void setButtons(String buttons) {
            this.buttons = buttons;
        }
    }
}

