/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.webui;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:resources/templates/webui/UIPublicationLogList.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationLogList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "PublicationLogListIterator");
    private Node currentNode_;

    public UIPublicationLogList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public void setNode(Node node) throws Exception {
        this.currentNode_ = node;
    }

    public List<HistoryBean> getLog() throws NotInPublicationLifecycleException, Exception {
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        String[][] array = publicationService.getLog(this.currentNode_);
        ArrayList<HistoryBean> list = new ArrayList<HistoryBean>();
        for (int i = 0; i < array.length; ++i) {
            HistoryBean bean = new HistoryBean();
            String[] currentLog = array[i];
            bean.setDate(currentLog[0]);
            bean.setNewState(currentLog[1]);
            bean.setUser(currentLog[2]);
            String[] values = new String[currentLog.length - 4];
            for (int j = 4; j < currentLog.length; ++j) {
                values[j - 4] = currentLog[j];
            }
            String description = publicationService.getLocalizedAndSubstituteLog(((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale(), currentLog[3], values);
            bean.setDescription(description);
            list.add(bean);
        }
        return list;
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getLog(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getLogList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public class HistoryBean {
        private String date;
        private String newState;
        private String user;
        private String description;

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getNewState() {
            return this.newState;
        }

        public void setNewState(String newState) {
            this.newState = newState;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPublicationLogList> {
        public void execute(Event<UIPublicationLogList> event) throws Exception {
            UIPublicationLogList uiPublicationLogList = (UIPublicationLogList)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiPublicationLogList.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }
}

