/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.util.Hashtable;
import java.util.Locale;
import org.exoplatform.services.workflow.Form;

public class FormCache {
    Hashtable<String, Hashtable<String, Hashtable<Locale, Form>>> forms = new Hashtable();

    public Form getForm(String processId, String stateName, Locale locale) {
        Hashtable<String, Hashtable<Locale, Form>> states = this.forms.get(processId);
        if (states == null) {
            return null;
        }
        Hashtable<Locale, Form> locales = states.get(stateName);
        if (locales == null) {
            return null;
        }
        return locales.get(locale);
    }

    public void removeForms(String processId) {
        this.forms.remove(processId);
    }

    public void setForm(String processId, String stateName, Locale locale, Form form) {
        Hashtable<Locale, Object> locales;
        Hashtable<String, Hashtable<Locale, Object>> states = this.forms.get(processId);
        if (states == null) {
            states = new Hashtable();
            this.forms.put(processId, states);
        }
        if ((locales = states.get(stateName)) == null) {
            locales = new Hashtable();
            states.put(stateName, locales);
        }
        locales.put(locale, form);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (String processId : this.forms.keySet()) {
            ret.append("Process Id = " + processId + "\n");
            Hashtable<String, Hashtable<Locale, Form>> states = this.forms.get(processId);
            for (String stateName : states.keySet()) {
                ret.append("  State Name = " + stateName + "\n");
                Hashtable<Locale, Form> locales = states.get(stateName);
                for (Locale locale : locales.keySet()) {
                    ret.append("    Locale = " + locale.toString() + "\n");
                }
            }
        }
        return ret.toString();
    }
}

