/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import hero.interfaces.BnNodeLocal;
import hero.interfaces.BnNodePropertyLocal;
import hero.interfaces.BnProjectLocal;
import hero.interfaces.BnProjectLocalHome;
import hero.interfaces.BnProjectPK;
import hero.interfaces.BnProjectPropertyLocal;
import hero.interfaces.BnProjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.impl.bonita.AutomaticFormBundle;
import org.exoplatform.services.workflow.impl.bonita.ProcessData;

public class AutomaticFormImpl
implements Form {
    private ResourceBundle bundle;
    private String stateName;
    private List<Map<String, Object>> submitButtons;
    private Hashtable<String, Map<String, Object>> variables;

    public AutomaticFormImpl(String processId, String stateName, Locale locale) {
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal projectModel = projectHome.findByPrimaryKey(new BnProjectPK(processId));
            if (ProcessData.START_STATE_NAME.equals(stateName)) {
                this.stateName = ProcessData.START_STATE_NAME;
                this.bundle = new AutomaticFormBundle("start");
                this.variables = new Hashtable();
                this.submitButtons = new ArrayList<Map<String, Object>>();
                ((AutomaticFormBundle)this.bundle).addDefaultButton();
                this.initializeProjectVariables(projectModel);
            } else {
                BnNodeLocal node = projectModel.getBnNode(stateName);
                this.stateName = node.getName();
                this.bundle = new AutomaticFormBundle(this.stateName);
                this.variables = new Hashtable();
                this.submitButtons = new ArrayList<Map<String, Object>>();
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", "submit");
                attributes.put("transition", "");
                this.submitButtons.add(attributes);
                ((AutomaticFormBundle)this.bundle).addButton(attributes);
                this.initializeNodeVariables(node);
                this.initializeProjectVariables(projectModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCustomizedView() {
        return null;
    }

    public String getIconURL() {
        return "";
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public String getStateImageURL() {
        return "";
    }

    public String getStateName() {
        return this.stateName;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    public List getVariables() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> attributes : this.variables.values()) {
            ret.add(attributes);
        }
        return ret;
    }

    private void initializeNodeVariables(BnNodeLocal node) {
        Collection properties = node.getBnProperties();
        for (BnNodePropertyLocal property : properties) {
            String name = property.getTheKey();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", name);
            attributes.put("editable", "true");
            attributes.put("mandatory", "false");
            Collection possibleValues = property.getPossibleValues();
            if (possibleValues != null) {
                attributes.put("component", "select");
                attributes.put("possible-values", possibleValues);
            } else {
                attributes.put("component", "text");
            }
            this.variables.put(name, attributes);
            ((AutomaticFormBundle)this.bundle).addVariable(attributes);
        }
    }

    private void initializeProjectVariables(BnProjectLocal projectModel) {
        Collection properties = projectModel.getBnProperties();
        for (BnProjectPropertyLocal property : properties) {
            String name = property.getTheKey();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", name);
            attributes.put("editable", "true");
            attributes.put("mandatory", "false");
            Collection possibleValues = property.getPossibleValues();
            if (possibleValues != null) {
                attributes.put("component", "select");
                attributes.put("possible-values", possibleValues);
            } else {
                attributes.put("component", "text");
            }
            this.variables.put(name, attributes);
            ((AutomaticFormBundle)this.bundle).addVariable(attributes);
        }
    }

    public boolean isCustomizedView() {
        return false;
    }

    public boolean isDelegatedView() {
        return false;
    }
}

