/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.jbpm.WorkflowServiceContainerImpl;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.db.JbpmSession;
import org.jbpm.db.SchedulerSession;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerListener;

public class ExoSchedulerThread
extends Thread {
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    List listeners = new ArrayList();
    boolean keepRunning = true;
    long interval = 5000L;
    private String containerName;

    public ExoSchedulerThread(String containerName) {
        super("exo workflow scheduler");
        this.containerName = containerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            long millisToWait = this.interval;
            try {
                millisToWait = this.executeTimers();
                if (millisToWait < 0L) {
                    millisToWait = this.interval;
                }
                millisToWait = Math.min(millisToWait, this.interval);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    Thread.sleep(millisToWait);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeTimers() {
        long millisTillNextTimerIsDue = -1L;
        boolean isDueDateInPast = true;
        boolean exceptionOccured = true;
        PortalContainer container = RootContainer.getInstance().getPortalContainer(this.containerName);
        PortalContainer.setInstance((PortalContainer)container);
        WorkflowServiceContainerImpl workflowContainer = (WorkflowServiceContainerImpl)container.getComponentInstanceOfType(WorkflowServiceContainer.class);
        JbpmSession jbpmSession = workflowContainer.openSession();
        try {
            SchedulerSession schedulerSession = new SchedulerSession(jbpmSession);
            Iterator iter = schedulerSession.findTimersByDueDate();
            while (iter.hasNext() && isDueDateInPast) {
                Timer timer = (Timer)iter.next();
                if (timer.isDue()) {
                    timer.execute();
                    this.notifyListeners(timer);
                    if (timer.getException() != null) {
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    if (timer.getRepeat() != null) {
                        Date dueDate = timer.getDueDate();
                        while (dueDate.getTime() <= System.currentTimeMillis()) {
                            dueDate = businessCalendar.add(dueDate, new Duration(timer.getRepeat()));
                        }
                        timer.setDueDate(dueDate);
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    schedulerSession.deleteTimer(timer);
                    continue;
                }
                isDueDateInPast = false;
                millisTillNextTimerIsDue = timer.getDueDate().getTime() - System.currentTimeMillis();
            }
            exceptionOccured = false;
        }
        finally {
            if (exceptionOccured) {
                workflowContainer.rollback(jbpmSession);
            } else {
                workflowContainer.closeSession(jbpmSession);
            }
            PortalContainer.setInstance(null);
        }
        return millisTillNextTimerIsDue;
    }

    public void addListener(SchedulerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(SchedulerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void notifyListeners(Timer timer) {
        if (this.listeners != null) {
            Date now = new Date();
            for (SchedulerListener timerRunnerListener : new ArrayList(this.listeners)) {
                timerRunnerListener.timerExecuted(now, timer);
            }
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

