/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeExport;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormTableInputSet;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ExportActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={UncheckAllActionListener.class}), @EventConfig(listeners={CheckAllActionListener.class})})
public class UINodeTypeExport
extends UIForm {
    static final String TABLE_NAME = "UINodeTypeExport";
    static final String LABEL = "label";
    static final String INPUT = "input";
    static final String[] TABLE_COLUMNS = new String[]{"label", "input"};
    private List<NodeType> nodeTypeList_ = new ArrayList();

    public void update() throws Exception {
        UIFormTableInputSet uiTableInputSet = (UIFormTableInputSet)this.createUIComponent(UIFormTableInputSet.class, null, null);
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        ExtendedNodeTypeManager ntManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        uiTableInputSet.setName(TABLE_NAME);
        uiTableInputSet.setColumns(TABLE_COLUMNS);
        while (nodeTypeIter.hasNext()) {
            NodeType nt = nodeTypeIter.nextNodeType();
            this.nodeTypeList_.add(nt);
            String ntName = nt.getName();
            UIFormInputSet uiInputSet = new UIFormInputSet(ntName);
            UIFormInputInfo uiInfo = new UIFormInputInfo(LABEL, null, ntName);
            uiInputSet.addChild((UIComponent)uiInfo);
            UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(ntName, ntName, null);
            uiCheckbox.setChecked(true);
            uiCheckbox.setValue((Object)ntName);
            uiInputSet.addChild((UIComponent)uiCheckbox);
            uiTableInputSet.addChild((UIComponent)uiInputSet);
        }
        this.setActions(new String[]{"Export", "Cancel", "UncheckAll"});
        this.addUIFormInput((UIFormInputSet)uiTableInputSet);
    }

    public String getLabel(String id) {
        return id;
    }

    public NodeType getNodeTypeByName(String nodeTypeName) throws Exception {
        NodeType nodeTypeSelected = null;
        for (NodeType node : this.nodeTypeList_) {
            if (!node.getName().equals(nodeTypeName)) continue;
            nodeTypeSelected = node;
            break;
        }
        return nodeTypeSelected;
    }
}

