/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;

@ComponentConfig(template="app:/groovy/webui/component/admin/nodetype/UINodeTypeList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UINodeTypeList.msg.confirm-delete"), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ExportActionListener.class})})
public class UINodeTypeList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UINodeTypeListIterator");
    public static final String DRAFTNODETYPE = "jcr:system/jcr:nodetypesDraft";
    public static final String[] ACTIONS = new String[]{"Add", "Import", "Export"};
    public static final String[] CANCEL = new String[]{"Cancel"};
    public static final String[] TAB_REMOVE = new String[]{"SuperTypeTab", "DefaultTypeTab", "RequiredTypeTab"};

    public UINodeTypeList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public List getAllNodeTypes() throws Exception {
        ArrayList<Object> nodeList = new ArrayList<Object>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ManageableRepository mRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        ExtendedNodeTypeManager ntManager = mRepository.getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        while (nodeTypeIter.hasNext()) {
            nodeList.add(nodeTypeIter.nextNodeType());
        }
        Collections.sort(nodeList, new Utils.NodeTypeNameComparator());
        Session session = mRepository.getSystemSession(mRepository.getConfiguration().getSystemWorkspaceName());
        if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
            Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
            NodeIterator nodeIter = draftNode.getNodes();
            while (nodeIter.hasNext()) {
                nodeList.add(nodeIter.nextNode());
            }
        }
        session.logout();
        return nodeList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getNodeTypeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(String name) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ManageableRepository manaRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        Session session = manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
        if (name != null) {
            if (session.getRootNode().hasNode(DRAFTNODETYPE)) {
                Node draftNode = session.getRootNode().getNode(DRAFTNODETYPE);
                if (draftNode.hasNode(name)) {
                    Node deleteNode = draftNode.getNode(name);
                    deleteNode.remove();
                    draftNode.save();
                }
                if (!draftNode.hasNodes()) {
                    draftNode.remove();
                }
                session.save();
            }
        } else {
            session.refresh(true);
        }
        session.logout();
        ObjectPageList pageList = new ObjectPageList(this.getAllNodeTypes(), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }
}

