/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryForm;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep1;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep2;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep3;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizard;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizardContainer;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.ValueStorageFilterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/UIWorkspaceWizard.gtmpl", events={@EventConfig(listeners={AddPermissionActionListener.class}), @EventConfig(listeners={SelectContainerActionListener.class}), @EventConfig(listeners={SelectStoreActionListener.class}), @EventConfig(listeners={SelectQueryHandlerActionListener.class}), @EventConfig(listeners={FinishActionListener.class}), @EventConfig(listeners={NextActionListener.class}), @EventConfig(listeners={BackActionListener.class}), @EventConfig(listeners={ViewStep1ActionListener.class}), @EventConfig(listeners={ViewStep2ActionListener.class}), @EventConfig(listeners={ViewStep3ActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditPermissionActionListener.class}), @EventConfig(listeners={RemovePermissionActionListener.class}), @EventConfig(listeners={ChangeTypeStoreActionListener.class})})
public class UIWorkspaceWizard
extends UIFormTabPane
implements UISelector {
    private int wizardMaxStep_ = 3;
    private int selectedStep_ = 1;
    private int currentStep_ = 0;
    private String selectedWsName_ = null;
    private Map<Integer, String> chidrenMap_ = new HashMap();
    public boolean isNewWizard_ = true;
    public boolean isNewRepo_ = true;
    public boolean isCheckValid_ = true;
    public boolean hasCheckDefault_ = false;
    private Map<Integer, String[]> actionMap_ = new HashMap();
    public static final String POPUPID = "UIPopupWindowInWizard";
    public static final String FIELD_STEP1 = "step1";
    public static final String FIELD_STEP2 = "step2";
    public static final String FIELD_STEP3 = "step3";
    public static final String KEY_SWAPDIRECTORY = "swap-directory";
    public static final String KEY_SOURCENAME = "sourceName";
    public static final String KEY_DIALECT = "dialect";
    public static final String KEY_MULTIDB = "multi-db";
    public static final String KEY_MAXBUFFER = "max-buffer-size";
    public static final String KEY_PATH = "path";
    public static final String KEY_INDEXDIR = "indexDir";
    public static final String KEY_MAXSIZE = "maxSize";
    public static final String KEY_LIVETIME = "liveTime";
    public static final String KEY_UPDATESTORE = "update-storage";
    public static final String KEY_CONTAINERTYPE = "org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer";
    public static final String KEY_STORETYPE = "org.exoplatform.services.jcr.impl.storage.value.fs.SimpleFileValueStorage";
    public static final String KEY_TREE_STORETYPE = "org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileValueStorage";
    public static final String KEY_QUERYHANDLER = "org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex";

    public UIWorkspaceWizard() throws Exception {
        super("UIWorkspaceWizard");
        this.chidrenMap_.put(1, FIELD_STEP1);
        this.chidrenMap_.put(2, FIELD_STEP2);
        this.chidrenMap_.put(3, FIELD_STEP3);
        this.actionMap_.put(1, new String[]{"Next", "Cancel"});
        this.actionMap_.put(2, new String[]{"Back", "Next", "Cancel"});
        this.actionMap_.put(3, new String[]{"Back", "Finish", "Cancel"});
        UIWizardStep1 step1 = new UIWizardStep1(FIELD_STEP1);
        UIWizardStep2 step2 = new UIWizardStep2(FIELD_STEP2);
        UIWizardStep3 step3 = new UIWizardStep3(FIELD_STEP3);
        this.addUIComponentInput((UIComponent)step1);
        this.addUIComponentInput((UIComponent)step2);
        this.addUIComponentInput((UIComponent)step3);
        this.setRenderedChild(this.getCurrentChild());
    }

    protected void removePopup(String id) {
        ((UIWorkspaceWizardContainer)this.getAncestorOfType(UIWorkspaceWizardContainer.class)).removePopup(id);
    }

    protected void lockForm(boolean isLock) {
        UIWizardStep1 wsStep1 = (UIWizardStep1)this.getChildById(FIELD_STEP1);
        wsStep1.lockFields(isLock);
        UIWizardStep2 wsStep2 = (UIWizardStep2)this.getChildById(FIELD_STEP2);
        wsStep2.lockFields(isLock);
        UIWizardStep3 wsStep3 = (UIWizardStep3)this.getChildById(FIELD_STEP3);
        wsStep3.lockFields(isLock);
    }

    public void setCurrentSep(int step) {
        this.currentStep_ = step;
    }

    public int getCurrentStep() {
        return this.currentStep_;
    }

    public void setSelectedStep(int step) {
        this.selectedStep_ = step;
    }

    public int getSelectedStep() {
        return this.selectedStep_;
    }

    public int getMaxStep() {
        return this.wizardMaxStep_;
    }

    public String[] getActions() {
        return (String[])this.actionMap_.get(this.selectedStep_);
    }

    public String getCurrentChild() {
        return (String)this.chidrenMap_.get(this.selectedStep_);
    }

    public String[] getCurrentAction() {
        return (String[])this.actionMap_.get(this.selectedStep_);
    }

    protected void refresh(WorkspaceEntry workSpace) throws Exception {
        this.reset();
        UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)this.getChildById(FIELD_STEP1);
        UIWizardStep2 uiWSFormStep2 = (UIWizardStep2)this.getChildById(FIELD_STEP2);
        UIWizardStep3 uiWSFormStep3 = (UIWizardStep3)this.getChildById(FIELD_STEP3);
        uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setChecked(false);
        UIRepositoryForm uiRepoForm = (UIRepositoryForm)((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).findFirstComponentOfType(UIRepositoryForm.class);
        String repoName = (String)uiRepoForm.getUIStringInput("name").getValue();
        String name = "";
        boolean isDefaultWS = false;
        String lockTime = "0";
        String dbType = null;
        String selectedNodeType = null;
        String permission = null;
        String containerType = "";
        String swapPath = "";
        String sourceName = "";
        boolean isMutil = false;
        String storeType = "";
        String storePath = "";
        String filterType = "";
        String queryHandlerType = "";
        String indexDir = "";
        String maxBuffer = "204800";
        boolean isEnableCache = true;
        String maxCache = "5000";
        String liveTime = "30000";
        if (workSpace != null) {
            CacheEntry cache;
            QueryHandlerEntry queryHandler;
            ArrayList valueStore;
            ContainerEntry container;
            if (!this.isNewWizard_) {
                name = workSpace.getName();
                isDefaultWS = uiRepoForm.isDefaultWorkspace(name);
                selectedNodeType = workSpace.getAutoInitializedRootNt();
            }
            permission = workSpace.getAutoInitPermissions();
            if (workSpace.getLockManager() != null) {
                lockTime = String.valueOf(workSpace.getLockManager().getTimeout());
            }
            if ((container = workSpace.getContainer()) != null) {
                containerType = container.getType();
                swapPath = container.getParameterValue(KEY_SWAPDIRECTORY);
                sourceName = container.getParameterValue(KEY_SOURCENAME);
                dbType = container.getParameterValue(KEY_DIALECT);
                isMutil = Boolean.parseBoolean(container.getParameterValue(KEY_MULTIDB));
                maxBuffer = container.getParameterValue(KEY_MAXBUFFER);
            }
            if ((valueStore = container.getValueStorages()) != null && valueStore.size() > 0) {
                storeType = ((ValueStorageEntry)valueStore.get(0)).getType();
                storePath = ((ValueStorageEntry)valueStore.get(0)).getParameterValue(KEY_PATH);
                filterType = ((ValueStorageFilterEntry)((ValueStorageEntry)valueStore.get(0)).getFilters().get(0)).getPropertyType();
            }
            if ((queryHandler = workSpace.getQueryHandler()) != null) {
                queryHandlerType = queryHandler.getType();
                indexDir = queryHandler.getParameterValue(KEY_INDEXDIR);
            }
            if ((cache = workSpace.getCache()) != null) {
                isEnableCache = cache.isEnabled();
                maxCache = cache.getParameterValue(KEY_MAXSIZE);
                liveTime = cache.getParameterValue(KEY_LIVETIME);
            }
            uiWSFormStep1.fillFields(name, selectedNodeType, isDefaultWS, permission, lockTime);
            uiWSFormStep2.fillFields(containerType, sourceName, dbType, isMutil, storeType, storePath, filterType, maxBuffer, swapPath);
            uiWSFormStep3.fillFields(queryHandlerType, indexDir, isEnableCache, maxCache, liveTime);
            if (this.isNewWizard_) {
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                if (this.isNewRepo_) {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEditable(true);
                    sb1.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1)).append(repoName).append("/");
                    sb2.append(storePath.substring(0, storePath.lastIndexOf("/") + 1)).append(repoName).append("/");
                } else {
                    sb1.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1));
                    sb2.append(storePath.substring(0, storePath.lastIndexOf("/") + 1));
                }
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)sb1.toString());
                uiWSFormStep2.getUIStringInput("storePath").setValue((Object)sb2.toString());
                uiWSFormStep2.getUIFormSelectBox("filterType").setValue(filterType);
            }
        }
        if (this.isNewRepo_) {
            this.lockForm(false);
        } else if (this.isNewWizard_) {
            this.lockForm(false);
            uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEnable(false);
        } else {
            this.lockForm(true);
        }
        if (this.isNewWizard_) {
            this.isCheckValid_ = true;
        } else if (this.isNewRepo_) {
            this.isCheckValid_ = true;
            if (workSpace != null) {
                this.selectedWsName_ = workSpace.getName();
            }
        } else {
            this.isCheckValid_ = false;
        }
    }

    public String url(String name) throws Exception {
        UIComponent renderedChild = this.getChild(this.currentStep_);
        if (!(renderedChild instanceof UIForm)) {
            return super.event(name);
        }
        Event event = this.config.getUIComponentEventConfig(name);
        if (event == null) {
            return "??config??";
        }
        UIForm uiForm = (UIForm)renderedChild;
        return uiForm.event(name);
    }

    public int getNumberSteps() {
        return this.wizardMaxStep_;
    }

    public void viewStep(int step) {
        this.selectedStep_ = step;
        this.currentStep_ = step - 1;
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (i == this.getCurrentStep()) {
                ((UIComponent)children.get(i)).setRendered(true);
                continue;
            }
            ((UIComponent)children.get(i)).setRendered(false);
        }
    }

    protected boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    protected String autoInitStorePath(String storePath, String repoName, String wsName) {
        StringBuilder sb = new StringBuilder();
        sb.append(storePath.substring(0, storePath.lastIndexOf("/") + 1)).append(repoName).append("/").append(wsName);
        return sb.toString();
    }

    protected String autoInitSwapPath(String swapPath, String repoName, String wsName) {
        StringBuilder sb = new StringBuilder();
        sb.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1)).append(repoName).append("/").append(wsName);
        return sb.toString();
    }

    public void updateSelect(String selectField, String value) {
        UIFormInputSetWithAction uiFormAction = (UIFormInputSetWithAction)this.getChildById(FIELD_STEP1);
        UIFormStringInput permissionField = uiFormAction.getUIStringInput("permission");
        permissionField.setValue((Object)value);
    }

    protected void showHidden(boolean isChecked) {
        this.getUIStringInput("storePath").setRendered(isChecked);
        this.getUIStringInput("filterType").setRendered(isChecked);
        this.getUIStringInput("storeType").setRendered(isChecked);
        if (isChecked) {
            // empty if block
        }
    }

    public void setContainerName(String value) {
        UIFormInputSet uiWSFormStep2 = (UIFormInputSet)this.getChildById(FIELD_STEP2);
        uiWSFormStep2.getUIStringInput("container").setValue((Object)value);
    }

    public void setStoreTypeName(String value) {
        UIFormInputSet uiWSFormStep2 = (UIFormInputSet)this.getChildById(FIELD_STEP2);
        uiWSFormStep2.getUIStringInput("storeType").setValue((Object)value);
    }

    public void setQueryHandlerName(String value) {
        UIFormInputSet uiWSFormStep3 = (UIFormInputSet)this.getChildById(FIELD_STEP3);
        uiWSFormStep3.getUIStringInput("queryHandler").setValue((Object)value);
    }

    static /* synthetic */ String access$000(UIWorkspaceWizard x0) {
        return x0.selectedWsName_;
    }
}

