/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.JCRExceptionManager;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.admin.views.UITabForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewList;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/UIFormInputSetWithAction.gtmpl")
public class UIViewForm
extends UIFormInputSetWithAction
implements UISelector {
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_NAME = "viewName";
    public static final String FIELD_PERMISSION = "permission";
    public static final String FIELD_TABS = "tabs";
    public static final String FIELD_TEMPLATE = "template";
    public static final String FIELD_ENABLEVERSION = "enableVersion";
    private boolean isView_ = true;
    private Node views_;
    private HashMap<String, ViewConfig.Tab> tabMap_ = new HashMap();
    private ManageViewService vservice_ = null;
    private List<String> listVersion = new ArrayList();
    private Version baseVersion_;
    private VersionNode selectedVersion_;

    public String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }

    public UIViewForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_VERSION, FIELD_VERSION, options);
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_TABS, FIELD_TABS, null));
        this.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        String repository = this.getRepository();
        Node ecmTemplateHome = this.vservice_.getTemplateHome("ecmExplorerTemplates", repository, SessionsUtils.getSessionProvider());
        ArrayList<SelectItemOption> temp = new ArrayList<SelectItemOption>();
        if (ecmTemplateHome != null) {
            NodeIterator iter = ecmTemplateHome.getNodes();
            while (iter.hasNext()) {
                Node tempNode = iter.nextNode();
                temp.add(new SelectItemOption(tempNode.getName(), (Object)tempNode.getPath()));
            }
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TEMPLATE, FIELD_TEMPLATE, temp));
        UIFormCheckBoxInput enableVersion = new UIFormCheckBoxInput(FIELD_ENABLEVERSION, FIELD_ENABLEVERSION, null);
        enableVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)enableVersion);
        this.setActions(new String[]{"Save", "Reset", "Cancel"}, null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void updateSelect(String selectField, String value) {
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)value);
        UIViewContainer uiContainer = (UIViewContainer)this.getAncestorOfType(UIViewContainer.class);
        uiContainer.removeChildById("PopupViewPermission");
    }

    public boolean isView() {
        return this.isView_;
    }

    public Node getViews() {
        return this.views_;
    }

    public boolean canEnableVersionning(Node node) throws Exception {
        return node.canAddMixin("mix:versionable");
    }

    private boolean isVersioned(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        if (vH != null) {
            return new VersionNode(vH.getRootVersion());
        }
        return null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List child = new ArrayList();
        for (VersionNode vNode : children) {
            this.listVersion.add(vNode.getName());
            child = vNode.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt((String)versionList.get(j)) >= Integer.parseInt((String)versionList.get(i))) continue;
                String temp = (String)versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption((String)versionList.get(i), versionList.get(i)));
        }
        return options;
    }

    public void addTab(String tabName, String buttons) {
        ViewConfig.Tab tab = new ViewConfig.Tab();
        tab.setTabName(tabName);
        tab.setButtons(buttons);
        this.tabMap_.put(tabName, tab);
    }

    private String getTabList() throws Exception {
        StringBuilder result = new StringBuilder();
        ArrayList tabList = new ArrayList(this.tabMap_.values());
        if (result != null) {
            for (ViewConfig.Tab tab : tabList) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(tab.getTabName());
            }
        }
        return result.toString();
    }

    public void refresh(boolean isAddNew) throws Exception {
        this.getUIFormSelectBox(FIELD_VERSION).setRendered(!isAddNew);
        this.getUIFormSelectBox(FIELD_VERSION).setDisabled(!isAddNew);
        this.getUIStringInput(FIELD_NAME).setEditable(isAddNew).setValue(null);
        this.getUIStringInput(FIELD_PERMISSION).setValue(null);
        this.getUIFormInputInfo(FIELD_TABS).setEditable(isAddNew).setValue(null);
        this.getUIFormSelectBox(FIELD_TEMPLATE).setValue(null);
        this.getUIFormSelectBox(FIELD_TEMPLATE).setDisabled(!isAddNew);
        this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(!isAddNew);
        if (isAddNew) {
            this.setActions(new String[]{"Save", "Reset", "Cancel"}, null);
            this.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
            this.tabMap_.clear();
            this.views_ = null;
            this.setActionInfo(FIELD_TABS, null);
        }
        this.selectedVersion_ = null;
        this.baseVersion_ = null;
    }

    public void update(Node viewNode, boolean isView, VersionNode selectedVersion) throws Exception {
        String[] actionInfor;
        ViewConfig.Tab tabObj;
        String buttons;
        Node tab;
        NodeIterator iter;
        this.isView_ = isView;
        if (viewNode != null) {
            this.views_ = viewNode;
            if (this.isVersioned(this.views_)) {
                this.baseVersion_ = this.views_.getBaseVersion();
            }
            this.tabMap_.clear();
            iter = this.views_.getNodes();
            while (iter.hasNext()) {
                tab = iter.nextNode();
                buttons = tab.getProperty("exo:buttons").getString();
                tabObj = new ViewConfig.Tab();
                tabObj.setTabName(tab.getName());
                tabObj.setButtons(buttons);
                this.tabMap_.put(tab.getName(), tabObj);
            }
            this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(true);
            if (this.isVersioned(this.views_)) {
                this.getUIFormSelectBox(FIELD_VERSION).setOptions(this.getVersionValues(this.views_)).setRendered(true);
                this.getUIFormSelectBox(FIELD_VERSION).setValue(this.baseVersion_.getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setEnable(true);
            } else if (!this.isVersioned(this.views_)) {
                this.getUIFormSelectBox(FIELD_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setEnable(true);
            }
        }
        if (selectedVersion != null) {
            this.views_.restore(selectedVersion.getVersion(), false);
            this.views_.checkout();
            this.tabMap_.clear();
            iter = this.views_.getNodes();
            while (iter.hasNext()) {
                tab = iter.nextNode();
                buttons = tab.getProperty("exo:buttons").getString();
                tabObj = new ViewConfig.Tab();
                tabObj.setTabName(tab.getName());
                tabObj.setButtons(buttons);
                this.tabMap_.put(tab.getName(), tabObj);
            }
            this.selectedVersion_ = selectedVersion;
        }
        if (this.views_ != null) {
            this.getUIStringInput(FIELD_NAME).setEditable(false).setValue((Object)this.views_.getName());
            this.getUIStringInput(FIELD_PERMISSION).setValue((Object)this.views_.getProperty("exo:permissions").getString());
            this.getUIFormSelectBox(FIELD_TEMPLATE).setValue(this.views_.getProperty("exo:template").getString());
        }
        this.setInfoField(FIELD_TABS, this.getTabList());
        if (this.isView_) {
            actionInfor = new String[]{"EditTab"};
            this.setIsView(true);
        } else {
            actionInfor = new String[]{"EditTab", "DeleteTab"};
            this.setIsView(false);
        }
        this.setActionInfo(FIELD_TABS, actionInfor);
    }

    public void save() throws Exception {
        String permissions;
        String[] arrFilterChar;
        String viewName = (String)this.getUIStringInput(FIELD_NAME).getValue();
        if (viewName == null || viewName.trim().length() == 0) {
            throw new MessageException(new ApplicationMessage("UIViewForm.msg.view-name-invalid", null, 1));
        }
        for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!", "#", "/", "\\"}) {
            if (viewName.indexOf(filterChar) <= -1) continue;
            throw new MessageException(new ApplicationMessage("UIViewForm.msg.fileName-invalid", null, 1));
        }
        boolean isEnableVersioning = this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).isChecked();
        String repository = this.getRepository();
        List viewList = this.vservice_.getAllViews(this.getRepository());
        UIPopupWindow uiPopup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
        if (uiPopup.getId().equals("AddPopup")) {
            for (ViewConfig view : viewList) {
                if (!view.getName().equals(viewName) || isEnableVersioning) continue;
                ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.view-exist", null, 1);
                throw new MessageException(message);
            }
        }
        if ((permissions = (String)this.getUIStringInput(FIELD_PERMISSION).getValue()) == null || permissions.length() < 1) {
            ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.permission-not-empty", null, 1);
            throw new MessageException(message);
        }
        if (this.tabMap_.size() < 1) {
            ApplicationMessage message = new ApplicationMessage("UIViewForm.msg.mustbe-add-tab", null, 1);
            throw new MessageException(message);
        }
        String template = (String)this.getUIFormSelectBox(FIELD_TEMPLATE).getValue();
        ArrayList tabList = new ArrayList(this.tabMap_.values());
        if (this.views_ == null || !isEnableVersioning) {
            this.vservice_.addView(viewName, permissions, template, tabList, repository);
            if (this.views_ != null) {
                NodeIterator iter = this.views_.getNodes();
                while (iter.hasNext()) {
                    Node tab = iter.nextNode();
                    if (this.tabMap_.containsKey(tab.getName())) continue;
                    tab.remove();
                }
                this.views_.save();
            }
        } else {
            if (!this.isVersioned(this.views_)) {
                this.views_.addMixin("mix:versionable");
                this.views_.save();
            } else {
                this.views_.checkout();
            }
            NodeIterator iter = this.views_.getNodes();
            while (iter.hasNext()) {
                Node tab = iter.nextNode();
                if (this.tabMap_.containsKey(tab.getName())) continue;
                tab.remove();
            }
            this.vservice_.addView(viewName, permissions, template, tabList, repository);
            try {
                this.views_.save();
                this.views_.checkin();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
        }
        ((UIViewList)((UIViewContainer)this.getAncestorOfType(UIViewContainer.class)).getChild(UIViewList.class)).updateViewListGrid();
        this.refresh(true);
    }

    public void editTab(String tabName) throws Exception {
        UIViewFormTabPane viewTabPane = (UIViewFormTabPane)this.getParent();
        UITabForm tabForm = (UITabForm)viewTabPane.getChild(UITabForm.class);
        tabForm.update((ViewConfig.Tab)this.tabMap_.get(tabName), this.isView_);
        viewTabPane.setSelectedTab(tabForm.getId());
    }

    public void deleteTab(String tabName) throws Exception {
        this.tabMap_.remove(tabName);
        this.update(null, false, null);
        UIViewFormTabPane viewTabPane = (UIViewFormTabPane)this.getParent();
        UIViewContainer uiViewContainer = (UIViewContainer)this.getAncestorOfType(UIViewContainer.class);
        UIViewList uiViewList = (UIViewList)uiViewContainer.getChild(UIViewList.class);
        uiViewList.updateViewListGrid();
        UIViewForm uiViewForm = (UIViewForm)viewTabPane.getChild(UIViewForm.class);
        viewTabPane.setSelectedTab(uiViewForm.getId());
    }

    public void changeVersion() throws Exception {
        String path = this.views_.getVersionHistory().getVersion((String)this.getUIFormSelectBox(FIELD_VERSION).getValue()).getPath();
        VersionNode selectedVesion = this.getRootVersion(this.views_).findVersionNode(path);
        this.update(null, false, selectedVesion);
    }

    public void revertVersion() throws Exception {
        if (this.selectedVersion_ != null && !this.selectedVersion_.equals(this.baseVersion_)) {
            this.views_.restore(this.baseVersion_, true);
        }
    }
}

