/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.ECMViewComponent;
import org.exoplatform.ecm.jcr.JCRResourceResolver;
import org.exoplatform.ecm.jcr.UIPopupComponent;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIDocumentDetail;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={DownloadActionListener.class})})
public class UIDocumentDetail
extends UIComponent
implements ECMViewComponent,
UIPopupComponent {
    protected Node node_;
    private String language_;
    private JCRResourceResolver jcrTemplateResourceResolver_;

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.isValidNode()) {
            this.setRendered(true);
            super.processRender(context);
        } else {
            this.setRendered(false);
        }
    }

    protected boolean isValidNode() throws Exception {
        if (this.node_ == null) {
            return false;
        }
        return this.getUIBrowseContainer().getNodeByPath(this.node_.getPath(), this.getWorkspaceName()) != null;
    }

    private UIBrowseContainer getUIBrowseContainer() {
        return (UIBrowseContainer)((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).findFirstComponentOfType(UIBrowseContainer.class);
    }

    public String getTemplatePath() {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
        try {
            return templateService.getTemplatePathByUser(false, this.getNodeType(), userName, repository);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getIcons(Node node, String type) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)type);
    }

    public String getTemplate() {
        return this.getTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.jcrTemplateResourceResolver_ == null) {
            this.newJCRTemplateResourceResolver();
        }
        return this.jcrTemplateResourceResolver_;
    }

    public void newJCRTemplateResourceResolver() {
        try {
            String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
            ManageableRepository mRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
            String systemWorkspace = mRepository.getConfiguration().getSystemWorkspaceName();
            Session session = SessionsUtils.getSystemProvider().getSession(systemWorkspace, mRepository);
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(session, "exo:templateFile");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    public Node getNode() throws Exception {
        if (this.node_.hasProperty("exo:language")) {
            String defaultLang = this.node_.getProperty("exo:language").getString();
            if (this.language_ == null) {
                this.language_ = defaultLang;
            }
            if (!this.language_.equals(defaultLang)) {
                Node curNode = this.node_.getNode("languages" + Utils.SLASH + this.language_);
                return curNode;
            }
        }
        return this.node_;
    }

    public Node getOriginalNode() throws Exception {
        return this.node_;
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = pcontext.getRequest();
        PortletPreferences portletPref = prequest.getPreferences();
        return portletPref;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public void setNode(Node docNode) {
        this.node_ = docNode;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.node_.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)this.node_, (String)this.getRepository(), (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.node_.hasProperty("exo:relation")) {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
            return templateService.isManagedNodeType(this.getNodeType(), repository);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
            return templateService.isManagedNodeType(nodeTypeName, repository);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider provider = SessionsUtils.getSessionProvider();
        for (String ws : workspaces) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            return node.hasProperty(property);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getNodeType() throws Exception {
        return this.node_.getPrimaryNodeType().getName();
    }

    public String getRssLink() {
        return null;
    }

    public boolean isRssLink() {
        return false;
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, this.getLanguage());
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.node_);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, repository);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        return ((ManageableRepository)this.node_.getSession().getRepository()).getConfiguration().getName();
    }

    public String getWorkspaceName() throws Exception {
        return this.node_.getSession().getWorkspace().getName();
    }

    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }

    public boolean isShowPlanView(Node node) throws Exception {
        return false;
    }

    public List<Node> getListNodes(Node node) throws Exception {
        NodeIterator childrenIterator = node.getNodes();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        while (childrenIterator.hasNext()) {
            Node child = (Node)childrenIterator.next();
            if (!Utils.isReadAuthorized((Node)child)) continue;
            childrenList.add(child);
        }
        return childrenList;
    }
}

