/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.SecurityService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/explorer/UIWorkingArea.gtmpl"), @ComponentConfig(type=UIRightClickPopupMenu.class, id="ECMContextMenu", template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={EditDocumentActionListener.class}), @EventConfig(listeners={CopyActionListener.class}), @EventConfig(listeners={CutActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIWorkingArea.msg.confirm-delete"), @EventConfig(listeners={LockActionListener.class}), @EventConfig(listeners={UnlockActionListener.class}), @EventConfig(listeners={CheckInActionListener.class}), @EventConfig(listeners={CheckOutActionListener.class}), @EventConfig(listeners={RenameActionListener.class}), @EventConfig(listeners={CustomActionListener.class}), @EventConfig(listeners={PasteActionListener.class})})})
public class UIWorkingArea
extends UIContainer {
    private static final String RELATION_PROP = "exo:relation";
    public static final String WS_NAME = "workspaceName";

    public UIWorkingArea() throws Exception {
        this.addChild(UIRightClickPopupMenu.class, "ECMContextMenu", null);
        this.addChild(UISideBar.class, null, null);
        this.addChild(UIDocumentWorkspace.class, null, null);
    }

    public boolean isShowSideBar() throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        return jcrExplorer.getPreference().isShowSideBar();
    }

    public void setShowSideBar(boolean b) throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        jcrExplorer.getPreference().setShowSideBar(b);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository repo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        String workspace = repo.getConfiguration().getDefaultWorkspaceName();
        Session session = SessionsUtils.getSystemProvider().getSession(workspace, repo);
        return session.getNodeByUUID(uuid);
    }

    protected Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public boolean isReferenceableNode(Node node) throws Exception {
        NodeType[] nodeTypes;
        for (NodeType type : nodeTypes = node.getMixinNodeTypes()) {
            if (!type.getName().equals("mix:referenceable")) continue;
            return true;
        }
        return false;
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isPreferenceNode(node);
    }

    public boolean isSameNameSibling(Node node) throws Exception {
        return node.getPath().endsWith("]");
    }

    public boolean isEditable(String nodePath, Session session) throws Exception {
        Node node = (Node)session.getItem(nodePath);
        return this.isEditable(node);
    }

    public boolean isEditable(Node node) throws Exception {
        String nodeType = node.getPrimaryNodeType().getName();
        for (String type : Utils.NON_EDITABLE_NODETYPES) {
            if (!type.equalsIgnoreCase(nodeType)) continue;
            return false;
        }
        return true;
    }

    public boolean isVersionableOrAncestor(Node node) throws RepositoryException {
        return Utils.isVersionable((Node)node) || this.isAncestorVersionable(node);
    }

    public String getVersionNumber(Node node) throws RepositoryException {
        if (!Utils.isVersionable((Node)node)) {
            return "-";
        }
        return node.getBaseVersion().getName();
    }

    public boolean isAncestorVersionable(Node node) throws RepositoryException {
        int depth = node.getDepth() - 1;
        Node parent = (Node)node.getAncestor(depth);
        while (parent != null && depth != 0) {
            if (parent.isNodeType("mix:versionable")) {
                return true;
            }
            parent = (Node)node.getAncestor(--depth);
        }
        return false;
    }

    private void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    public boolean isJcrViewEnable() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getPreference().isJcrEnable();
    }

    public String getActionsList(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        StringBuilder actionsList = new StringBuilder();
        boolean isEditable = this.isEditable(node);
        boolean isLocked = node.isLocked();
        boolean holdsLock = node.holdsLock();
        boolean isSameNameSibling = this.isSameNameSibling(node);
        boolean isJcrEnable = this.isJcrViewEnable();
        boolean isVersionable = Utils.isVersionable((Node)node);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (this.isVersionableOrAncestor(node)) {
            if (node.isCheckedOut()) {
                if (isVersionable) {
                    actionsList.append("CheckIn");
                }
                if (isEditable) {
                    actionsList.append(",EditDocument");
                }
                if (holdsLock) {
                    actionsList.append(",Unlock");
                } else if (!isLocked) {
                    actionsList.append(",Lock");
                }
                if (!isSameNameSibling) {
                    actionsList.append(",Copy");
                    actionsList.append(",Cut");
                }
                actionsList.append(",Rename");
                if (isJcrEnable) {
                    actionsList.append(",Save");
                }
                actionsList.append(",Delete");
            } else {
                if (isVersionable) {
                    actionsList.append(",CheckOut");
                }
                if (holdsLock) {
                    actionsList.append(",Unlock");
                } else if (!isLocked) {
                    actionsList.append(",Lock");
                }
                if (!isSameNameSibling) {
                    actionsList.append(",Copy");
                }
                actionsList.append(",Rename");
            }
        } else {
            if (isEditable) {
                actionsList.append(",EditDocument");
            }
            if (holdsLock) {
                actionsList.append(",Unlock");
            } else if (!isLocked) {
                actionsList.append(",Lock");
            }
            if (!isSameNameSibling) {
                actionsList.append(",Copy");
                actionsList.append(",Cut");
            }
            actionsList.append(",Rename");
            if (this.isJcrViewEnable()) {
                actionsList.append(",Save");
            }
            actionsList.append(",Delete");
        }
        if (uiExplorer.getAllClipBoard().size() > 0) {
            actionsList.append(",Paste");
        }
        return actionsList.toString();
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        ArrayList<Node> safeActions = new ArrayList<Node>();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String userName = context.getRemoteUser();
        ActionServiceContainer actionContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        List unsafeActions = actionContainer.getCustomActionsNode(node, "read");
        if (unsafeActions == null) {
            return new ArrayList<Node>();
        }
        SecurityService securityService = (SecurityService)this.getApplicationComponent(SecurityService.class);
        for (Node actionNode : unsafeActions) {
            Value[] roles = actionNode.getProperty("exo:roles").getValues();
            for (int i = 0; i < roles.length; ++i) {
                String role = roles[i].getString();
                if (!securityService.hasMembershipInGroup(userName, role)) continue;
                safeActions.add(actionNode);
            }
        }
        return safeActions;
    }

    static /* synthetic */ void access$000(UIWorkingArea x0, Node x1) throws Exception {
        x0.removeMixins(x1);
    }
}

