/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.jcr.UIPopupComponent;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.DialogFormFields;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={DialogFormFields.SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDocumentForm
extends DialogFormFields
implements UIPopupComponent,
UISelector {
    private String documentType_;
    private boolean isAddNew_ = false;

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public boolean isAddNew() {
        return this.isAddNew_;
    }

    public void addNew(boolean b) {
        this.isAddNew_ = b;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    public void updateSelect(String selectField, String value) {
        this.isUpdateSelect_ = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value);
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            UIFormInputBase input = (UIFormInputBase)inputSet.getChild(inputSet.getChildren().size() - 1);
            input.setValue((Object)value);
        }
        UIDocumentFormController uiContainer = (UIDocumentFormController)this.getParent();
        uiContainer.removeChildById("PopupComponent");
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            this.resetScriptInterceptor();
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, this.repositoryName_);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.documentType_};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public boolean isEditing() {
        return !this.isAddNew_;
    }

    public Node storeValue(Event event) throws Exception {
        String nodeType;
        Node homeNode;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        List inputs = this.getChildren();
        Map inputProperties = Utils.prepareMap((List)inputs, (Map)this.getInputProperties());
        Node newNode = null;
        Node currentNode = uiExplorer.getCurrentNode();
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        if (this.isAddNew()) {
            UIDocumentFormController uiDFController = (UIDocumentFormController)this.getParent();
            homeNode = currentNode;
            nodeType = ((UISelectDocumentForm)uiDFController.getChild(UISelectDocumentForm.class)).getSelectValue();
        } else {
            homeNode = this.getNode().getParent();
            nodeType = this.getNode().getPrimaryNodeType().getName();
            if (this.getNode().isLocked()) {
                this.getNode().getSession().addLockToken(Utils.getLockToken((Node)this.getNode()));
            }
        }
        try {
            CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
            String addedPath = cmsService.storeNode(nodeType, homeNode, inputProperties, this.isAddNew(), this.repositoryName_);
            try {
                homeNode.save();
                newNode = (Node)homeNode.getSession().getItem(addedPath);
            }
            catch (Exception e) {
                if (!uiExplorer.getPreference().isJcrEnable()) {
                    uiExplorer.getSession().save();
                }
                uiExplorer.updateAjax(event);
                return null;
            }
            if (!uiExplorer.getPreference().isJcrEnable()) {
                uiExplorer.getSession().save();
            }
            uiExplorer.updateAjax(event);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException(ace.getMessage());
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.in-versioning", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (ItemNotFoundException item) {
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.item-not-found", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (RepositoryException repo) {
            String key = "UIDocumentForm.msg.repository-exception";
            if (ItemExistsException.class.isInstance((Object)repo)) {
                key = "UIDocumentForm.msg.not-allowed-same-name-sibling";
            }
            uiApp.addMessage(new ApplicationMessage(key, null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (NumberFormatException nume) {
            String key = "UIDocumentForm.msg.numberformat-exception";
            uiApp.addMessage(new ApplicationMessage(key, null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (Exception e) {
            String key = "UIDocumentForm.msg.cannot-save";
            uiApp.addMessage(new ApplicationMessage(key, null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        return newNode;
    }
}

