/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.search.SearchResultPageList;
import org.exoplatform.ecm.webui.component.explorer.search.UIQueryResultPageIterator;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISearchResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={OpenFolderActionListener.class})})
public class UISearchResult
extends UIContainer {
    private QueryResult queryResult_;
    private long searchTime_ = 0L;
    private boolean flag_ = false;
    private boolean isQuickSearch_ = false;
    private UIQueryResultPageIterator uiPageIterator_;
    private List<Node> currentListNodes_ = new ArrayList();
    private int currentAvailablePage_ = 0;
    private boolean isEndOfIterator_ = false;
    private static int PAGE_SIZE = 10;

    public UISearchResult() throws Exception {
        this.uiPageIterator_ = (UIQueryResultPageIterator)this.addChild(UIQueryResultPageIterator.class, null, null);
    }

    public void setIsQuickSearch(boolean isQuickSearch) {
        this.isQuickSearch_ = isQuickSearch;
    }

    public void setQueryResults(QueryResult queryResult) throws Exception {
        this.queryResult_ = queryResult;
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public List getCurrentList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    private void addNode(List<Node> listNodes, Node node) throws Exception {
        List<Object> checkList = new ArrayList();
        checkList = this.flag_ ? this.currentListNodes_ : listNodes;
        if (node.getName().equals("jcr:content")) {
            if (!checkList.contains(node.getParent())) {
                listNodes.add(node.getParent());
            }
        } else if (!checkList.contains(node)) {
            listNodes.add(node);
        }
    }

    public List<Node> getResultList() throws Exception {
        ArrayList listNodes = new ArrayList();
        long resultListSize = this.queryResult_.getNodes().getSize();
        if (!this.queryResult_.getNodes().hasNext()) {
            return this.currentListNodes_;
        }
        if (resultListSize > 100L) {
            NodeIterator iter = this.queryResult_.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                this.addNode(listNodes, node);
                if (!iter.hasNext()) {
                    this.isEndOfIterator_ = true;
                }
                if (listNodes.size() == 100) {
                    this.currentListNodes_.addAll(listNodes);
                    break;
                }
                if (listNodes.size() < 100 && !iter.hasNext()) {
                    this.currentListNodes_.addAll(listNodes);
                }
                this.flag_ = true;
            }
        } else {
            NodeIterator iter = this.queryResult_.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!iter.hasNext()) {
                    this.isEndOfIterator_ = true;
                }
                this.addNode(listNodes, node);
            }
            this.currentListNodes_ = listNodes;
        }
        return this.currentListNodes_;
    }

    public void clearAll() {
        this.flag_ = false;
        this.isEndOfIterator_ = false;
        this.currentListNodes_.clear();
    }

    public UIQueryResultPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid() throws Exception {
        SearchResultPageList pageList = new SearchResultPageList(this.queryResult_, this.getResultList(), PAGE_SIZE, this.isEndOfIterator_);
        this.currentAvailablePage_ = this.currentListNodes_.size() / PAGE_SIZE;
        this.uiPageIterator_.setSearchResultPageList(pageList);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }

    public int getCurrentAvaiablePage() {
        return this.currentAvailablePage_;
    }

    static /* synthetic */ boolean access$000(UISearchResult x0) {
        return x0.isQuickSearch_;
    }
}

