/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={MoreConstraintsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveConstraintActionListener.class}, phase=Event.Phase.DECODE)})
public class UISimpleSearch
extends UIForm {
    public static final String INPUT_SEARCH = "input";
    public static final String CONSTRAINTS = "constraints";
    public static final String NODE_PATH = "nodePath";
    public static final String FIRST_OPERATOR = "firstOperator";
    public static final String OR = "or".intern();
    public static final String AND = "and".intern();
    private List<String> constraints_ = new ArrayList();
    private List<String> virtualConstraints_ = new ArrayList();
    private static final String ROOT_XPATH_QUERY = "//*";
    private static final String XPATH_QUERY = "/jcr:root$0//*";

    public UISimpleSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(NODE_PATH, NODE_PATH, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(INPUT_SEARCH, INPUT_SEARCH, null));
        ArrayList<SelectItemOption> operators = new ArrayList<SelectItemOption>();
        operators.add(new SelectItemOption(AND, (Object)AND));
        operators.add(new SelectItemOption(OR, (Object)OR));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIRST_OPERATOR, FIRST_OPERATOR, operators));
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("moreConstraints");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormInputInfo(CONSTRAINTS, CONSTRAINTS, null));
        this.addUIComponentInput((UIComponent)uiInputAct);
        this.setActions(new String[]{"MoreConstraints", "Search", "Save", "Cancel"});
    }

    public List<String> getConstraints() {
        return this.constraints_;
    }

    public void updateAdvanceConstraint(String constraint, String operator, String virtualDateQuery) {
        if (constraint.length() > 0) {
            if (this.constraints_.size() == 0) {
                this.constraints_.add("(" + constraint + " )");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add("(" + virtualDateQuery + " )");
                } else {
                    this.virtualConstraints_.add("(" + constraint + " )");
                }
            } else {
                this.constraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + virtualDateQuery + " ) ");
                } else {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                }
            }
        }
        UIFormInputSetWithAction inputInfor = (UIFormInputSetWithAction)this.getChildById("moreConstraints");
        inputInfor.setIsDeleteOnly(true);
        inputInfor.setListInfoField(CONSTRAINTS, this.virtualConstraints_);
        String[] actionInfor = new String[]{"RemoveConstraint"};
        inputInfor.setActionInfo(CONSTRAINTS, actionInfor);
    }

    private String getQueryStatement() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        String statement = "";
        String text = (String)this.getUIStringInput(INPUT_SEARCH).getValue();
        if (text != null && this.constraints_.size() == 0) {
            statement = "/".equals(currentNode.getPath()) ? "//*[(jcr:contains(.,'" + text + "'))" : StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()) + "[(jcr:contains(.,'" + text + "'))";
            statement = statement + "]";
        } else if (this.constraints_.size() > 0) {
            if (text == null) {
                statement = "/".equals(currentNode.getPath()) ? "//*[(" : StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()) + "[(";
            } else {
                String operator = (String)this.getUIFormSelectBox(FIRST_OPERATOR).getValue();
                statement = "/".equals(currentNode.getPath()) ? "//*[(jcr:contains(.,'" + text + "'))" : StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()) + "[(jcr:contains(.,'" + text + "'))";
                statement = statement + " " + operator + " (";
            }
            for (String constraint : this.constraints_) {
                statement = statement + constraint;
            }
            statement = statement + ")]";
        }
        return statement;
    }

    static /* synthetic */ List access$000(UISimpleSearch x0) {
        return x0.constraints_;
    }

    static /* synthetic */ String access$100(UISimpleSearch x0) throws Exception {
        return x0.getQueryStatement();
    }

    static /* synthetic */ List access$200(UISimpleSearch x0) {
        return x0.virtualConstraints_;
    }
}

