/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class SearchValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String inputValue = (String)uiInput.getValue();
        if (inputValue == null || inputValue.trim().length() == 0) {
            this.throwException("SearchValidator.msg.empty-input", uiInput);
        }
        inputValue = inputValue.trim();
        switch (inputValue.length()) {
            case 1: {
                this.checkOneChar(inputValue, uiInput);
                break;
            }
            case 2: {
                this.checkTwoChars(inputValue, uiInput);
                break;
            }
            default: {
                this.checkMoreChars(inputValue, uiInput);
            }
        }
    }

    private void checkOneChar(String s, UIFormInput uiInput) throws MessageException {
        String[] arrFilterChars = new String[]{"+", "-", "&", "|", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\"};
        if (this.checkArr(s, arrFilterChars)) {
            this.throwException("SearchValidator.msg.Invalid-char", uiInput);
        }
    }

    private void checkTwoChars(String s, UIFormInput uiInput) throws MessageException {
        String s2 = "";
        if (s.startsWith("+") || s.startsWith("-") || s.startsWith("!")) {
            s2 = s.substring(1, 2);
            this.checkOneChar(s2, uiInput);
        } else if (s.endsWith("~") || s.endsWith("?") || s.endsWith("*")) {
            String[] arrFilterChars1;
            s2 = s.substring(0, 1);
            if (this.checkArr(s2, arrFilterChars1 = new String[]{"+", "-", "&", "|", "!", "(", ")", "{", "}", "[", "]", "^", "\"", ":", "\\"})) {
                this.throwException("SearchValidator.msg.Invalid-char", uiInput);
            }
        } else {
            String s3 = s.substring(0, 1);
            String s4 = s.substring(1, 2);
            String[] arrFilterChars2 = new String[]{"+", "-", "&", "|", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\"};
            if (this.checkArr(s3, arrFilterChars2)) {
                this.throwException("SearchValidator.msg.Invalid-char", uiInput);
            }
            if (this.checkArr(s4, arrFilterChars2)) {
                this.throwException("SearchValidator.msg.Invalid-char", uiInput);
            }
        }
    }

    private void checkMoreChars(String s, UIFormInput uiInput) throws MessageException {
        String[] arrFilterChars2;
        String[] arrFilterChars;
        for (String filter : arrFilterChars = new String[]{"-", "&&", "||", "!", "(", ")", "}", "]", "^", ":", "&", "|"}) {
            if (!s.startsWith(filter)) continue;
            this.throwException("SearchValidator.msg.Invalid-char", uiInput);
        }
        for (String filter : arrFilterChars2 = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\", "&", "|"}) {
            String subString;
            int index = s.indexOf(filter);
            if (index <= -1 || this.checkBackSlash(s, index)) continue;
            if (filter.equals("~")) {
                if (index == 0) {
                    String regex = "~\\w+";
                    if (s.matches(regex)) continue;
                    this.throwException("SearchValidator.msg.Invalid-char", uiInput);
                    continue;
                }
                if (this.checkChar(s, index, -1, " ") || this.checkChar(s, index, 1, " ")) {
                    this.throwException("SearchValidator.msg.Invalid-char4", uiInput);
                    continue;
                }
                if (this.checkChar(s, index, -1, "\"")) {
                    int x = s.indexOf("\"");
                    if (x > -1 && x != index - 1) {
                        try {
                            String subString2 = this.concatSpace(s.substring(index + 1, s.length()));
                            Double.parseDouble(subString2);
                        }
                        catch (Exception e) {
                            this.throwException("SearchValidator.msg.Invalid-char2", uiInput);
                        }
                        continue;
                    }
                    this.throwException("SearchValidator.msg.Invalid-char", uiInput);
                    continue;
                }
                subString = this.concatSpace(s.substring(index + 1, s.length()));
                double numberAt = 0.0;
                try {
                    numberAt = Double.parseDouble(subString);
                }
                catch (NumberFormatException e) {
                    this.throwException("SearchValidator.msg.Invalid-char2", uiInput);
                }
                if (!(numberAt >= 1.0) && !(numberAt < 0.0)) continue;
                this.throwException("SearchValidator.msg.Invalid-char1", uiInput);
                continue;
            }
            if (filter.equals("^")) {
                if (this.checkChar(s, index, -1, " ") || this.checkChar(s, index, 1, " ")) {
                    this.throwException("SearchValidator.msg.Invalid-char5", uiInput);
                    continue;
                }
                subString = this.concatSpace(s.substring(index + 1, s.length()));
                try {
                    Double.parseDouble(subString);
                }
                catch (NumberFormatException e) {
                    this.throwException("SearchValidator.msg.Invalid-char3", uiInput);
                }
                continue;
            }
            if (filter.equals("*") && index == 0) {
                return;
            }
            if (filter.equals("?") && index == 0) {
                return;
            }
            this.throwException("SearchValidator.msg.Invalid-char", uiInput);
        }
    }

    private boolean checkChar(String s, int index, int forward, String c) {
        if (index == 0 || index + forward == s.length()) {
            return false;
        }
        String charToString = String.valueOf(s.charAt(index + forward));
        return charToString.equals(c);
    }

    private boolean checkBackSlash(String s, int index) {
        if (index == 0) {
            return false;
        }
        String charToString = String.valueOf(s.charAt(index - 1));
        return charToString.equalsIgnoreCase("\\");
    }

    private boolean checkArr(String s, String[] arrFilterChars) {
        for (String filter : arrFilterChars) {
            if (!s.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private String concatSpace(String s) {
        char[] arrayChar = s.toCharArray();
        int index = 0;
        for (int i = 0; i < arrayChar.length; ++i) {
            if (!String.valueOf(arrayChar[i]).equals(" ")) continue;
            index = i;
            break;
        }
        if (index != 0) {
            return s.substring(0, index);
        }
        return s;
    }

    private void throwException(String s, UIFormInput uiInput) throws MessageException {
        Object[] args = new Object[]{uiInput.getName()};
        throw new MessageException(new ApplicationMessage(s, args, 1));
    }
}

