/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.UIJCRBrowser;
import org.exoplatform.ecm.webui.component.UIWorkspaceList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIFormWithoutAction.gtmpl", events={@EventConfig(listeners={ChangeWorkspaceActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UIWorkspaceList
extends UIForm {
    private static String WORKSPACE_NAME = "workspaceName";
    private static String ROOT_NODE_INFO = "rootNodeInfo";
    private static String ROOT_NODE_PATH = "rootNodePath";
    private List<String> wsList_;
    private boolean isShowSystem_ = true;

    public UIWorkspaceList() throws Exception {
        ArrayList wsList = new ArrayList();
        UIFormSelectBox uiWorkspaceList = new UIFormSelectBox(WORKSPACE_NAME, WORKSPACE_NAME, wsList);
        uiWorkspaceList.setOnChange("ChangeWorkspace");
        this.addUIFormInput((UIFormInput)uiWorkspaceList);
        UIFormInputSetWithAction rootNodeInfo = new UIFormInputSetWithAction(ROOT_NODE_INFO);
        rootNodeInfo.addUIFormInput((UIFormInput)new UIFormInputInfo(ROOT_NODE_PATH, ROOT_NODE_PATH, null));
        String[] actionInfor = new String[]{"AddRootNode"};
        rootNodeInfo.setActionInfo(ROOT_NODE_PATH, actionInfor);
        rootNodeInfo.showActionInfo(true);
        rootNodeInfo.setRendered(false);
        this.addUIComponentInput((UIComponent)rootNodeInfo);
    }

    public void setIsShowSystem(boolean isShowSystem) {
        this.isShowSystem_ = isShowSystem;
    }

    public void setShowRootPathSelect(boolean isRender) {
        UIFormInputSetWithAction uiInputAction = (UIFormInputSetWithAction)this.getChildById(ROOT_NODE_INFO);
        uiInputAction.setRendered(isRender);
    }

    public void setWorkspaceList(String repository) throws Exception {
        this.wsList_ = new ArrayList();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String[] wsNames = repositoryService.getRepository(repository).getWorkspaceNames();
        String systemWsName = repositoryService.getRepository(repository).getConfiguration().getSystemWorkspaceName();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        for (String wsName : wsNames) {
            if (!this.isShowSystem_) {
                if (wsName.equals(systemWsName)) continue;
                workspace.add(new SelectItemOption(wsName, (Object)wsName));
                this.wsList_.add(wsName);
                continue;
            }
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
            this.wsList_.add(wsName);
        }
        UIFormSelectBox uiWorkspaceList = this.getUIFormSelectBox(WORKSPACE_NAME);
        uiWorkspaceList.setOptions(workspace);
        UIJCRBrowser uiBrowser = (UIJCRBrowser)this.getParent();
        if (uiBrowser.getWorkspace() != null && this.wsList_.contains(uiBrowser.getWorkspace())) {
            uiWorkspaceList.setValue(uiBrowser.getWorkspace());
        }
    }

    public void setIsDisable(String wsName, boolean isDisable) {
        if (this.wsList_.contains(wsName)) {
            this.getUIFormSelectBox(WORKSPACE_NAME).setValue(wsName);
        }
        this.getUIFormSelectBox(WORKSPACE_NAME).setDisabled(isDisable);
    }

    static /* synthetic */ String access$000() {
        return WORKSPACE_NAME;
    }
}

