/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryControl;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositorySelectForm;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/UIRepositoryControl.gtmpl", events={@EventConfig(listeners={EditRepositoryActionListener.class}), @EventConfig(listeners={RemoveRepositoryActionListener.class}), @EventConfig(listeners={AddRepositoryActionListener.class})})
public class UIRepositoryControl
extends UIContainer {
    public UIRepositoryControl() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        String repository = pref.getValue(Utils.REPOSITORY, "");
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        UIRepositorySelectForm uiSelectForm = (UIRepositorySelectForm)this.createUIComponent(UIRepositorySelectForm.class, null, null);
        try {
            rservice.getRepository(repository);
            uiSelectForm.setOptionValue(this.getRepoItem(true, rservice));
            uiSelectForm.setSelectedValue(repository);
        }
        catch (Exception e) {
            uiSelectForm.setOptionValue(this.getRepoItem(false, rservice));
            uiSelectForm.setSelectedValue("");
        }
        uiSelectForm.setActionEvent();
        this.addChild((UIComponent)uiSelectForm);
    }

    protected List<SelectItemOption<String>> getRepoItem(boolean isExists, RepositoryService rservice) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (!isExists) {
            options.add(new SelectItemOption("", (Object)""));
        }
        Iterator i$ = rservice.getConfig().getRepositoryConfigurations().iterator();
        while (i$.hasNext()) {
            RepositoryEntry obj;
            RepositoryEntry repo = obj = (RepositoryEntry)i$.next();
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    protected String getSelectedRepo() {
        return ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).getSelectedValue();
    }

    protected boolean isDefaultRepo(String repoName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rservice.getConfig().getDefaultRepositoryName().equals(repoName);
    }

    protected void reloadValue(boolean isExists, RepositoryService rservice) {
        ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setOptionValue(this.getRepoItem(isExists, rservice));
        if (isExists) {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            String repository = pref.getValue(Utils.REPOSITORY, "");
            ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setSelectedValue(repository);
        } else {
            ((UIRepositorySelectForm)this.getChild(UIRepositorySelectForm.class)).setSelectedValue("");
        }
    }
}

