/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.UIPopupComponent;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class})})
public class UIScriptForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_SELECT_VERSION = "selectVersion";
    public static final String FIELD_SCRIPT_CONTENT = "scriptContent";
    public static final String FIELD_SCRIPT_NAME = "scriptName";
    public static final String FIELD_ENABLE_VERSION = "enableVersion";
    public static final String SCRIPT_FILE_TYPE = ".groovy";
    private List<String> listVersion = new ArrayList();
    private boolean isAddNew_ = true;

    public UIScriptForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_SELECT_VERSION, FIELD_SELECT_VERSION, options);
        UIFormTextAreaInput contents = new UIFormTextAreaInput(FIELD_SCRIPT_CONTENT, FIELD_SCRIPT_CONTENT, null);
        contents.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormCheckBoxInput isVersion = new UIFormCheckBoxInput(FIELD_ENABLE_VERSION, FIELD_ENABLE_VERSION, null);
        UIFormStringInput scriptName = new UIFormStringInput(FIELD_SCRIPT_NAME, FIELD_SCRIPT_NAME, null);
        scriptName.addValidator(MandatoryValidator.class, new Object[0]);
        versions.setOnChange("Change");
        versions.setRendered(false);
        isVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)contents);
        this.addUIFormInput((UIFormInput)isVersion);
        this.addUIFormInput((UIFormInput)scriptName);
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        return vH == null ? null : new VersionNode(vH.getRootVersion());
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List child = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            this.listVersion.add(children.get(i).getName());
            child = children.get(i).getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt((String)versionList.get(j)) >= Integer.parseInt((String)versionList.get(i))) continue;
                String temp = (String)versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption((String)versionList.get(i), versionList.get(i)));
        }
        return options;
    }

    public void update(Node script, boolean isAddNew) throws Exception {
        this.isAddNew_ = isAddNew;
        if (script != null) {
            String scriptContent = script.getProperty("jcr:data").getString();
            this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(true);
            boolean isVersioned = script.isNodeType("mix:versionable");
            if (isVersioned) {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(true);
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setOptions(this.getVersionValues(script));
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setValue(script.getBaseVersion().getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(true);
                this.setActions(new String[]{"Save", "Restore", "Refresh", "Cancel"});
            } else {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
                this.setActions(new String[]{"Save", "Refresh", "Cancel"});
            }
            this.getUIStringInput(FIELD_SCRIPT_CONTENT).setValue((Object)scriptContent);
            this.getUIStringInput(FIELD_SCRIPT_NAME).setValue((Object)script.getName());
            this.getUIStringInput(FIELD_SCRIPT_NAME).setEditable(false);
            return;
        }
        if (!this.isAddNew_) {
            this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
            return;
        }
        this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setEditable(true);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setValue(null);
        this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ boolean access$000(UIScriptForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ VersionNode access$100(UIScriptForm x0, Node x1) throws Exception {
        return x0.getRootVersion(x1);
    }
}

