/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UILanguageTypeForm;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIFormWithoutAction.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ChangeLanguageActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SetDefaultActionListener.class})})
public class UILanguageTypeForm
extends UIForm {
    public static final String LANGUAGE_TYPE = "typeLang";
    public static final String DEFAULT_TYPE = "default";

    public UILanguageTypeForm() throws Exception {
        UIFormSelectBox uiSelectForm = new UIFormSelectBox(LANGUAGE_TYPE, LANGUAGE_TYPE, this.languages());
        uiSelectForm.setOnChange("ChangeLanguage");
        this.addUIFormInput((UIFormInput)uiSelectForm);
        UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(DEFAULT_TYPE, DEFAULT_TYPE, null);
        uiCheckbox.setOnChange("SetDefault");
        this.addUIFormInput((UIFormInput)uiCheckbox);
    }

    public void resetLanguage() {
        this.getUIFormSelectBox(LANGUAGE_TYPE).setValue("");
        this.getUIFormCheckBoxInput(DEFAULT_TYPE).setChecked(false);
    }

    public List<SelectItemOption<String>> languages() throws Exception {
        LocaleConfigService localService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        ArrayList<SelectItemOption<String>> languages = new ArrayList<SelectItemOption<String>>();
        Iterator iter = localService.getLocalConfigs().iterator();
        languages.add(new SelectItemOption("- - - -", (Object)""));
        while (iter.hasNext()) {
            LocaleConfig localConfig = (LocaleConfig)iter.next();
            languages.add((SelectItemOption<String>)new SelectItemOption(localConfig.getLocale().getDisplayLanguage(), (Object)localConfig.getLocale().getLanguage()));
        }
        return languages;
    }
}

