/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UITabForm
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "tabName";
    private List buttons_;

    public UITabForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        ManageViewService vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.buttons_ = vservice_.getButtons();
        for (Object bt : this.buttons_) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(bt.toString(), "", null));
        }
        this.setActions(new String[]{"Save", "Reset"}, null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void refresh(boolean isEditable) throws Exception {
        this.getUIStringInput(FIELD_NAME).setEditable(isEditable).setValue(null);
        for (Object bt : this.buttons_) {
            this.getUIFormCheckBoxInput(bt.toString()).setChecked(false).setEditable(isEditable);
        }
        if (isEditable) {
            this.setActions(new String[]{"Save", "Reset"}, null);
        }
    }

    public void update(ViewConfig.Tab tab, boolean isView) throws Exception {
        String[] buttonArray;
        this.refresh(!isView);
        if (tab == null) {
            return;
        }
        this.getUIStringInput(FIELD_NAME).setEditable(false).setValue((Object)tab.getTabName());
        String buttonsProperty = tab.getButtons();
        for (String bt : buttonArray = StringUtils.split((String)buttonsProperty, (String)";")) {
            UIFormCheckBoxInput cbInput = this.getUIFormCheckBoxInput(bt.trim());
            if (cbInput == null) continue;
            cbInput.setChecked(true);
        }
    }

    public void save() throws Exception {
        String[] arrFilterChar;
        String tabName = (String)this.getUIStringInput(FIELD_NAME).getValue();
        UIViewFormTabPane viewFormTabPane = (UIViewFormTabPane)this.getParent();
        UIViewForm uiViewForm = (UIViewForm)viewFormTabPane.getChild(UIViewForm.class);
        UITabForm uiTabForm = (UITabForm)viewFormTabPane.getChild(UITabForm.class);
        if (tabName == null || tabName.trim().length() == 0) {
            viewFormTabPane.setSelectedTab(uiTabForm.getId());
            throw new MessageException(new ApplicationMessage("UITabForm.msg.tab-name-error", null, 1));
        }
        for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!"}) {
            if (tabName.indexOf(filterChar) <= -1) continue;
            throw new MessageException(new ApplicationMessage("UITabForm.msg.fileName-invalid", null, 1));
        }
        StringBuilder selectedButton = new StringBuilder();
        boolean isSelected = false;
        for (Object bt : this.buttons_) {
            String button = bt.toString();
            if (!this.getUIFormCheckBoxInput(button).isChecked()) continue;
            isSelected = true;
            if (selectedButton.length() > 0) {
                selectedButton.append(";").append(button);
                continue;
            }
            selectedButton.append(button);
        }
        if (!isSelected) {
            viewFormTabPane.setSelectedTab(uiTabForm.getId());
            throw new MessageException(new ApplicationMessage("UITabForm.msg.button-select-error", null));
        }
        viewFormTabPane.setSelectedTab(uiViewForm.getId());
        uiViewForm.addTab(tabName, selectedButton.toString());
        uiViewForm.update(null, false, null);
        this.refresh(true);
    }
}

